#pragma once

#include <list>
#include <vector>
#include "mof/Graphics.h"
#include "mof/GraphicsSchedule.h"
#include "Common.h"

namespace et{
	class BattlerFacade;
	
	class Action
	{
		std::vector<BattlerFacade*> m_targetList;
	protected:
		BattlerFacade* m_pBattler;
		virtual int doActionTo(et::BattlerFacade* pTarget) = 0;
		int m_cost;
	public:
		Action(et::BattlerFacade* pBattler , et::BattlerFacade* pTarget , int cost);
		Action(et::BattlerFacade* pBattler , std::vector<BattlerFacade*>& targetList , int cost);
		virtual ~Action(void);
		std::vector<int> doAction();
		std::vector<BattlerFacade*>& getTargetList(){return m_targetList;}
		void setTargetList(std::vector<BattlerFacade*>& targetList);
		int getAPCost(){return m_cost;}
		virtual mof::AnimationResource createApproachAnimation() = 0;
		virtual mof::AnimationResource createExecuteAnimation() = 0;
		virtual mof::tstring getActionMessage() = 0;
		virtual bool isDirectAttack(){return false;}

		virtual mof::GraphicsSchedule* createEffect(et::Common& common);
	};


}