#include "BattlerGroup.h"
#include "BattlerFacade.h"
#include "DataBasedBattler.h"
#include <stdexcept>

et::BattlerGroup::~BattlerGroup(){
	for(std::vector<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		delete *itr;
	}
}

void et::BattlerGroup::addBattler(BattlerType type, et::BattlerFacade *pBattler){
	if(et::ENEMY == type)m_enemyBattlerList.push_back(pBattler);
	else if(et::IDEAL == type)m_idealBattlerList.push_back(pBattler);
	else m_heroBattlerList.push_back(pBattler);

	m_battlerList.push_back(pBattler);
}


et::BattlerFacade* et::BattlerGroup::getBattlerAt(int index) const{
	return m_battlerList.at(index);
}


const std::vector<et::BattlerFacade*>& et::BattlerGroup::getBattlerList() const{
	return m_battlerList;
}


const std::vector<et::BattlerFacade*> et::BattlerGroup::getBattlerListAlive() const{
	std::vector<BattlerFacade*> result;
	for(std::vector<BattlerFacade*>::const_iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getParameter().alive)result.push_back(*itr);
	}
	return result;
}



et::BattlerFacade* et::BattlerGroup::getEnemyBattlerAt(int index) const{
	return m_enemyBattlerList.at(index);
}


et::BattlerFacade* et::BattlerGroup::getIdealBattlerAt(int index) const{
	return m_idealBattlerList.at(index);
}


et::BattlerFacade* et::BattlerGroup::getHeroBattler() const{
	return m_heroBattlerList.at(0);
}

const std::vector<et::BattlerFacade*>& et::BattlerGroup::getEnemyBattlerList() const{
	return m_enemyBattlerList;
}

const std::vector<et::BattlerFacade*> et::BattlerGroup::getEnemyBattlerListAlive() const{
	std::vector<BattlerFacade*> result;
	for(std::vector<BattlerFacade*>::const_iterator itr = m_enemyBattlerList.begin() ; itr != m_enemyBattlerList.end() ; ++itr){
		if((*itr)->getParameter().alive)result.push_back(*itr);
	}
	return result;
}


const std::vector<et::BattlerFacade*>& et::BattlerGroup::getIdealBattlerList() const{
	return m_idealBattlerList;
}


const std::vector<et::BattlerFacade*> et::BattlerGroup::getIdealBattlerListAlive() const{
	std::vector<BattlerFacade*> result;
	for(std::vector<BattlerFacade*>::const_iterator itr = m_idealBattlerList.begin() ; itr != m_idealBattlerList.end() ; ++itr){
		if((*itr)->getParameter().alive)result.push_back(*itr);
	}
	return result;
}


void et::BattlerGroup::addEnemyBattlers(mof::DataRow& unitData , et::Common& common){
	TCHAR* columnTable[] = {_T("Monster1") , _T("Monster2") , _T("Monster3")};
	TCHAR suffixTable[] = {_T('A') , _T('B') , _T('C')};
	mof::tstring nameTable[3];
	for(int i = 0 ; i < 3 ; i++){
		try{
			nameTable[i] = unitData.getData(columnTable[i]);
		}catch(std::logic_error e){
			return;
		}
		if(nameTable[i] == _T(""))continue;
		int count = 0;
		for(int j = 0 ; j < i  ; j++){
			if(nameTable[i] == nameTable[j])count++;
		}
		addBattler(et::ENEMY, new DataBasedBattler( nameTable[i].c_str() , common.m_pDataResourceManager ,  common.m_pTextureManager , suffixTable[count]));
	}
}