#pragma once
#include <vector>
#include "BattlerType.h"
#include "mof/DataRow.h"
#include "Common.h"

namespace et{
	class BattlerFacade;

	class BattlerGroup
	{
		
		std::vector<BattlerFacade*> m_enemyBattlerList;
		std::vector<BattlerFacade*> m_idealBattlerList;
		std::vector<BattlerFacade*> m_heroBattlerList;
		std::vector<BattlerFacade*> m_battlerList;

		BattlerGroup(const BattlerGroup&){;}
		BattlerGroup& operator=(const BattlerGroup&){return *this;}
	public:
		BattlerGroup(){;}
		~BattlerGroup();

		void addBattler(BattlerType type , BattlerFacade* pBattler);
		void addEnemyBattlers(mof::DataRow& unitData , et::Common& common);
		BattlerFacade* getBattlerAt(int index) const;
		const std::vector<BattlerFacade*>& getBattlerList() const;
		const std::vector<BattlerFacade*> getBattlerListAlive() const;
		BattlerFacade* getEnemyBattlerAt(int index) const;
		BattlerFacade* getIdealBattlerAt(int index) const;
		BattlerFacade* getHeroBattler() const;

		const std::vector<BattlerFacade*>& getEnemyBattlerList() const;
		const std::vector<BattlerFacade*> getEnemyBattlerListAlive() const;
		const std::vector<BattlerFacade*>& getIdealBattlerList() const;
		const std::vector<BattlerFacade*> getIdealBattlerListAlive() const;
		
	};


}