#pragma once
#include "mof/AbstractScene.h"
#include "mof/Graphics.h"
#include "mof/InputReceiver.h"
#include "GameData.h"
#include "mof/Capturer.h"
#include "mof/DataTable.h"

namespace et{
	class GameScene :
		public mof::AbstractScene
	{
	protected:
		mof::Capturer* m_pCapturer;
		GameData* m_pGameData;
		mof::InputReceiver* m_pInputReceiver;
		mof::MeshManager* m_pMeshManager;
		mof::TextureManager* m_pTextureManager;
		mof::DataResourceManager* m_pDataResourceManager;
	public:
		GameScene(void);
		virtual ~GameScene(void);

		void setMeshManager(mof::MeshManager* pMeshManager);
		void setTextureManager(mof::TextureManager* pTextureManager);
		void setGameData(GameData* pGameData);
		void setCapturer(mof::Capturer* pCapturer);
		void setInputReceiver(mof::InputReceiver* pInputReceiver);
		void setDataResourceManager(mof::DataResourceManager* pDataResourceManager);
	};


};