#include "ItemMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "TargetMenu.h"



mof::Window* et::ItemMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}

et::ItemMenu::ItemMenu( mof::TextureManager* pTextureManager , std::list<et::ItemData>& itemDataList , et::ItemOperatorFactory* pNextMenuFactory )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame0.png")) ) , m_itemDataList(itemDataList)
{
	setColumn(2);
	setPaddingX(10);
	setPaddingY(5);
	/*for(std::list<et::ItemData&>::iterator itr = itemDataList.begin() ; itr != itemDataList.end() ; ++itr){
		m_itemDataList.push_back(*itr);
	}*/
	m_pNextMenuFactory = pNextMenuFactory;

	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	//ACẽXg쐬
	for(std::list<et::ItemData>::iterator itr = itemDataList.begin() ; itr != itemDataList.end() ; ++itr){
		pSelectable = addSelectableTextItem(this , selectables , (TCHAR*)(*itr).name.c_str() , 16);
	}

	if(selectables.size() == 0){
		pSelectable = addSelectableTextItem(this , selectables , _T("@@@@@@@@") , 16);
		pSelectable->setAvailable(false);
	}
	if(selectables.size() % 2 != 0){//vC
		pSelectable = addSelectableTextItem(this , selectables , _T("@@@@@@@@") , 16);
		pSelectable->setAvailable(false);
	}
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource() , 2);
	setVisible(true);
}

et::ItemMenu::~ItemMenu(void)
{
	delete m_pSelector;
	delete m_pNextMenuFactory;
}





void et::ItemMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 ,500));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 , 370));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 500));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::ItemMenu::performAction(){
	if(m_itemDataList.empty())return this;
	int index = getSelectionModel()->getSelectingIndex();
	
	et::ItemOperationMenu* pOperationMenu = m_pNextMenuFactory->create();
	int i = 0;
	for(std::list<et::ItemData>::iterator itr = m_itemDataList.begin() ; itr != m_itemDataList.end() ; ++itr , ++i){
		if(i == index)pOperationMenu->setTargetItem(&(*itr));

	}
	return pOperationMenu;
}


