#include "SpecialAction.h"
#include "BattlerFacade.h"
#include "mof/DataRow.h"
#include "mof/DataBasedAnimation.h"
#include "mof/KeyFrameAnimation.h"


et::SpecialAction::SpecialAction(et::BattlerFacade* pBattler , et::BattlerFacade* pTarget , int cost ,  int skillID)
: Action(pBattler , pTarget , cost)
{
	m_skillID = skillID;
}

et::SpecialAction::SpecialAction(et::BattlerFacade* pBattler , std::vector<et::BattlerFacade*>& targetList , int cost , int skillID)
: Action(pBattler , targetList , cost)
{
	m_skillID = skillID;
}

et::SpecialAction::~SpecialAction(void)
{
}


int et::SpecialAction::doActionTo(et::BattlerFacade* pTarget){
	float totalPower;
	switch(m_skillID){
		case 0 : totalPower = -40;
			break;
		case 1 : totalPower = -20;
			break;
		case 2 : totalPower = 60;
			break;
		default : totalPower = 100;
	}
	
	int damage = (int)-totalPower;
	if(pTarget->getParameter().guard)damage *= 0.5;//K[hȂǃ_[W
	int effect = -damage;

	et::BattlerParameter parameter = pTarget->getParameter();
	if(parameter.hp <= damage){
		parameter.hp = 0;
		parameter.alive = false;
	}
	else parameter.hp -= damage;
	if(parameter.hp > parameter.maxHp)parameter.hp = parameter.maxHp;
	parameter.dActionPoint += 1;
	pTarget->setParameter(parameter);
	return effect;
}

mof::AnimationResource et::SpecialAction::createApproachAnimation(){
	mof::Vector3D targetPosition = m_pBattler->getPosition();
	targetPosition.x += (m_pBattler->getType() == et::ENEMY)? 0.2f : -0.2f;
	return m_pBattler->setMovingAnimation(targetPosition , 15);
}

mof::AnimationResource et::SpecialAction::createExecuteAnimation(){
	return m_pBattler->setCastAnimation(1);
}



mof::GraphicsSchedule* et::SpecialAction::createEffect(et::Common& common){
	
	mof::DataResource effectTable;
	switch(m_skillID){
		case 0 : effectTable = common.m_pDataResourceManager->getResource(_T("data/effect/flame.csv"));
			break;
		case 1 : effectTable = common.m_pDataResourceManager->getResource(_T("data/effect/flame.csv"));
			break;
		case 2 : effectTable = common.m_pDataResourceManager->getResource(_T("data/effect/shock.csv"));
			break;
		default : effectTable = common.m_pDataResourceManager->getResource(_T("data/effect/shock.csv"));
	}

	mof::GraphicsSchedule* pSchedule = new mof::GraphicsSchedule();

	for(int i = 0 ; i < effectTable->getNumberOfRows() ; i++){
		mof::DataRow effectRow = mof::DataRow(effectTable , i);
		std::vector<et::BattlerFacade*> targetList = getTargetList();
		for(std::vector<et::BattlerFacade*>::iterator itr = targetList.begin() ; itr != targetList.end() ; ++itr){
			//---[V̍\
			mof::CascadeAnimation* pCascadeAnimation = new mof::CascadeAnimation();
		
			mof::KeyFrameAnimation* pCommonAnimation = new mof::KeyFrameAnimation();
			mof::Vector3D targetPosition = (*itr)->getPosition();
			mof::Vector3D basePosition = m_pBattler->getGraphicsObject()->getPosition();
			//XP[vZ
			mof::Vector3D scale = targetPosition - basePosition;
			scale.y = 1.0;
			pCommonAnimation->setPosition(0 , basePosition);
			mof::AnimationResource resource(pCommonAnimation);

			mof::tstring motionName(effectRow.getData(_T("Motion")));
			mof::DataBasedAnimation* pMotionAnimation = new mof::DataBasedAnimation(motionName.c_str() , scale);
			pCascadeAnimation->setElement(0 , mof::AnimationResource(pMotionAnimation));
		
			pCascadeAnimation->setElement(1 , resource);
			mof::AnimationResource animation(pCascadeAnimation);

			//---IuWFNg̍\
			mof::tstring className(effectRow.getData(_T("Class")));

			mof::tstring textureName(effectRow.getData(_T("Texture")));
			if(textureName == _T(""))textureName = _T("null");
			mof::TextureResource texture = common.m_pTextureManager->getResource(textureName.c_str());

			if(className == _T("Billboard")){
				//r{[h
				mof::GraphicsObject* pModel = new mof::Billboard(mof::Billboard::Y_FIXED , texture);
				pModel->setAnimation(0 , animation);
				pSchedule->add(20 , mof::GraphicsModelPtr(pModel) , animation);
			}
			else {
				//bV(classNamePath)
				mof::MeshResource pModel = common.m_pMeshManager->getResource(className.c_str());
				pModel->setTexture(0 , texture);
				pModel->setAnimation(0 , animation);
				pSchedule->add(20 , mof::GraphicsModelPtr(pModel) , animation);
			}
		}
		
	}
	
	
	return pSchedule;
}

mof::tstring et::SpecialAction::getActionMessage(){
	switch(m_skillID){
		case 0 : return mof::tstring(_T("ATgtC"));
		case 1 : return mof::tstring(_T("COjbV"));
		case 2 : return mof::tstring(_T("q[O"));
		default : return mof::tstring(_T("̂̉ʎ"));
	}

}