#include "resource.hpp"
#include <stdexcept>

namespace
{
    mof::TextureManagerHandler m_systemTextureManager;
    mof::MeshBuilderManagerHandler m_systemMeshBuilderManager;
    bool m_initialized = false;

    void initialize( )
    {
        m_systemTextureManager = mof::TextureManagerHandler( new mof::TextureManager );
        m_systemMeshBuilderManager = std::make_shared<mof::ResourceManager<mof::MeshBuilder>>();
		m_initialized = true;
    }
}
//{{{ getTextureResourceManager
mof::TextureManagerHandler 
getTextureResourceManager( ResourceGroup rg )
{
    if( !m_initialized )initialize();
    switch( rg )
    {
        case SYSTEM :
            return m_systemTextureManager;
        default :
            std::runtime_error("invalid resource group"); 
    }

}
//}}}
//{{{ getMeshBuilderResourceManager
mof::MeshBuilderManagerHandler 
getMeshBuilderResourceManager( ResourceGroup rg )
{
    if( !m_initialized )initialize();
    switch( rg )
    {
        case SYSTEM :
            return m_systemMeshBuilderManager;
        default :
            std::runtime_error("invalid resource group"); 
    }
}
//}}}
