#pragma once
#include <boost/multi_array.hpp>

//{{{ AreaPowerLevel
struct AreaPowerLevel
{
	int forest;
	int earth;

	AreaPowerLevel()
		: forest(0), earth(0)
	{
	}

	AreaPowerLevel(int arg_forest, int arg_earth)
		: forest(arg_forest), earth(arg_earth)
	{
	}

	AreaPowerLevel& operator += (const AreaPowerLevel level)
	{
		forest += level.forest;
		earth  += level.earth;
		if (forest > 9) forest = 9;
		if (earth > 9) earth = 9;
		return *this;
	}

};
//}}}
//{{{ LandPowerLevel
struct LandPowerLevel
{
	float ehves;
	float bolony;
	float stra;

	LandPowerLevel()
		: ehves(0), bolony(0), stra(0)
	{
	}

	LandPowerLevel& operator = (const LandPowerLevel& level)
	{
		ehves  = level.ehves;
		bolony = level.bolony;
		stra   = level.stra;
		return *this;
	}
	
	LandPowerLevel& operator += (const LandPowerLevel& level)
	{
		ehves += level.ehves;
		bolony  += level.bolony;
		stra  += level.stra;
		return *this;
	}
	
};
//}}}

struct Area
{
	AreaPowerLevel powerLevel;
	LandPowerLevel land_powerLevel;
	bool forest_element;
	bool earth_element;
	bool water_element;
	int land_id;
	bool land;///< ランドに属するか
	bool capital;///< ランドの中心エリアか
	int land_scale;//!< ランドの広さ

public :
	Area()
	{
		forest_element = earth_element = water_element = false;
		land_id = 0;
		land = false;
		capital = false;
		land_scale = 0;
	}
};

typedef boost::multi_array<AreaPowerLevel, 2> AreaPowerLevelMap;
typedef boost::multi_array<Area, 2> AreaMap;

