/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import com.docomostar.util.JarInflater;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;

public class StoreManager {
    public static final int NO_1 = 0;
    public static final int NO_2 = 1;
    public static final int NO_3 = 2;
    private static final int[] _SIZE = new int[]{1000, 1000, 1000};

    private void checkSize(int area, int offset, int len) throws IOException {
        if (area >= _SIZE.length) {
            throw new IOException("[checkSize \u7121\u52b9\u306a\u9818\u57df] area=" + area + ", offset=" + offset + ", len=" + len);
        }
        if (offset + len > _SIZE[area]) {
            throw new IOException("[checkSize overflow] area=" + area + ", offset=" + offset + ", len=" + len);
        }
    }

    public void clear(int area) throws IOException {
        this.checkSize(area, 0, 0);
        this.write(new byte[_SIZE[area]], area, 0);
    }

    public void write(byte[] data, int area, int offset) throws IOException, NullPointerException {
        if (data == null) {
            throw new NullPointerException("[write null] area=" + area + ", offset=" + offset);
        }
        this.checkSize(area, offset, data.length);
        FilterOutputStream out = null;
        try {
            try {
                out = Connector.openDataOutputStream((String)("scratchpad:///" + area + ";pos=" + offset));
                out.write(data);
                ((DataOutputStream)out).flush();
            }
            catch (IOException e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[write] area=" + area + ", offset=" + offset);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            out = null;
        }
    }

    public byte[] read(int area, int offset, int len) throws IOException {
        this.checkSize(area, offset, len);
        byte[] ret = new byte[len];
        FilterInputStream in = null;
        try {
            try {
                in = Connector.openDataInputStream((String)("scratchpad:///" + area + ";pos=" + offset));
                ((DataInputStream)in).read(ret);
            }
            catch (IOException e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[read] area=" + area + ", offset=" + offset + ", len=" + len);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            in = null;
        }
        return ret;
    }

    public InputStream readJar(int area, int offset, int len, String fname) throws IOException {
        this.checkSize(area, offset, len);
        InputStream in = null;
        JarInflater ji = null;
        try {
            try {
                byte[] b = this.read(area, offset, len);
                if (b != null) {
                    ji = new JarInflater(b);
                    in = ji.getInputStream(fname);
                }
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[readJar] area=" + area + ", offset=" + offset + ", len=" + len + ", fname=" + fname);
            }
        }
        finally {
            if (ji != null) {
                ji.close();
            }
            ji = null;
        }
        return in;
    }
}

