package mokit.ui;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connector;

import mokit.exception.MktUIException;

import com.docomostar.media.MediaManager;
import com.docomostar.media.MediaSound;
import com.docomostar.ui.UIException;

/**
 * TEhf[^Ǘ@\񋟂܂B
 * 
 * @author Takuto Nishioka
 */
public class SoundData {
	
	// TEhf[^
	private MediaSound _sound;

	/**
	 * RXgN^͉܂B
	 */
	public SoundData() {

	}

	/**
	 * bytef[^TEhZbg܂B
	 * 
	 * @param data
	 *        TEhf[^
	 * @throws MktUIException
	 *        TEhf[^̏Ɏsꍇɔ܂B
	 */
	public void setSound(byte[] data) throws MktUIException {

		try{
			_sound = MediaManager.getSound(data);
			_sound.use();

		}catch(IOException e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());
		}
	}

	/**
	 * t@Cw肵ăTEhZbg܂B
	 * 
	 * @param uri
	 *        TEht@C
	 * @throws MktUIException
	 *        TEhf[^̏Ɏsꍇɔ܂B
	 */
	public void setSound(String uri) throws MktUIException {

		InputStream in = null;
		try{
			in = Connector.openInputStream("resource:///" + uri);
			_sound = MediaManager.getSound(in);
			_sound.use();

		}catch(IOException e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());

		}finally{
			try{
				if(in != null) in.close();
			}catch(IOException e){
			}
		}
	}

	/**
	 * TEhf[^擾܂B
	 * 
	 * @return TEhf[^Ԃ܂B
	 */
	public MediaSound getSound() {

		return _sound;
	}

	/**
	 * TEhf[^J܂B
	 */
	public void release() {

		if(_sound != null){
			try{
				_sound.unuse();
				_sound.dispose();
			}catch(UIException e){
			}
			_sound = null;
		}
	}

}
