/*!
    \file  AbstractMonic.h
    \brief NICNX wb_
    
    Copyright (c) 2004 Yamami
    WITHOUT ANY WARRANTY

    \author  Yamami
    \version $Revision: 1.2 $
    \date   create:2004/09/04 update:$Date: 2004/10/31 14:29:43 $
*/
#ifndef _MONA_ABSTRACT_MONIC_
#define _MONA_ABSTRACT_MONIC_

#include <sys/types.h>

/*!
    abstract class AbstractMonic
*/
class AbstractMonic {

  private:

  protected:


  public:
  
    //Publico
    /*! \brief AbstractMonic e|Mobt@ */ 
    byte   frame_buf[1500];
    
    /*! \brief MACAhX */ 
    byte   ether_mac_addr[6];
    /*! \brief MpPbg{̂̒ */ 
    dword    frame_len;
    
    AbstractMonic();
    virtual ~AbstractMonic();
    
    //eC^[tF[X\bh TuNX(ۃNX(NIC)Ŏ)
    virtual void frame_input(void) = 0;
    virtual void frame_output( byte *, byte *, dword, word ) = 0;
    virtual int init(void) = 0;
    virtual int nic_probe(void) = 0;
    //virtual void nic_init(void) = 0;
    virtual void enableNetWork(void) = 0;
    virtual void disableNetWork(void) = 0;
    virtual int getNicIRQ() = 0;
    virtual void setNicIRQ(int) = 0;
    virtual int getNicIOBASE() = 0;
    virtual void setNicIOBASE(int) = 0;

};

#endif
