/*!
    \file  MoArp.h
    \brief ARPvgRNX wb_

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X Licnese

    \author  Yamami 
    \version $Revision: 1.2 $
    \date   create:2004/08/28 update:$Date: 2004/09/20 15:29:03 $
*/
#ifndef _MONA_MOARP_
#define _MONA_MOARP_

#include <sys/types.h>
#include <sys/HashMap.h>
#include <monapi.h>

#include "MoPacUtl.h"
#include "MonesDefine.h"
#include "AbstractMonic.h"

using namespace MonAPI;

/*! 
 *  \struct ARP_HEADER
 *  \brief ARPwb_\
 */
typedef struct{
    word hardType  __attribute__((packed));    //ʰ޳
    word protType  __attribute__((packed));    //ĺ
    byte  hardAddrLen  __attribute__((packed)); //ʰ޳ڽ
    byte  protAddrLen  __attribute__((packed)); //ĺٱڽ
    word opeCode  __attribute__((packed));     //ڰ
    byte  srcMac[6]  __attribute__((packed));   //Mʰ޳ڽ
    dword   srcIp  __attribute__((packed));       //Mĺٱڽ
    byte  dstMac[6]  __attribute__((packed));   //ޯʰ޳ڽ
    dword   dstIp  __attribute__((packed));       //ޯĺٱڽ
}ARP_HEADER;



enum{
    /* Hard type. */
    HARD_TYPE_ETHER= 1,     /* Ethernet. */

    /* Protocol type. */
    PROT_TYPE_IP=0x0800,    /* IP. */

    /* Operation code. */
    OPE_CODE_ARP_REQ= 1,    // ARPv
    OPE_CODE_ARP_REP= 2,    // ARP
    OPE_CODE_RARP_REQ=3,    // RARPv
    OPE_CODE_RARP_REP=4,    // RARP
};


enum{
    ARP_CACHE_NUM=64,               /* ARPLbVB */
};


/*!
    MoArp class
*/
class MoArp
{
    
  public:
    
    //RXgN^
    MoArp();
    ~MoArp();
    void initArp(AbstractMonic*);

    //int getMac(int,uint,char*);
    int receiveArp(ARP_HEADER*);
    char* searchCache(dword );
    int getMac(dword ,char*);

  private:
    //ARP 
    void transArp(dword , byte*, word );
    void addArpCache(dword , char*);
    
    
    //ARPLbVp HashMap
    HashMap<char*>* ArpCache;

    //NIChCo
    AbstractMonic* insAbstractNic;

};

#endif
