/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <baygui.h>

static unsigned int versionIcon_palette[] = {
	0xff242224,
	0xff9c9a9c,
	0xffcccecc,
	0xffeceeec,
	0xffec7264,
	0xffc4c2c4,
	0xffdcdedc,
	0xfffcfefc,
};

static unsigned char versionIcon_data[] = {
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x3,0x0,0x0,0x0,0x0,0x0,0x3,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x7,0x7,0x3,0x3,0x3,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x2,0x0,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x2,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x0,0x7,0x7,0x7,0x0,0x7,0x7,0x7,0x0,0x7,0x7,0x0,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x1,0x0,0x0,0x0,0x1,0x7,0x7,0x7,0x7,0x6,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x4,0x0,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x1,0x0,0x1,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x6,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x3,0x3,0x0,0x6,0x7,0x7,0x7,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x0,0x6,0x3,0x3,0x3,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
};

class GVersion : public Frame
{
public:
	GVersion::GVersion()
	{
		setBounds((800 - 270 - 12) / 2, (600 - 150 - 28) / 2, 282, 178);
		setTitle("ﾊﾞｰｼﾞｮﾝ情報");
	}

	GVersion::~GVersion()
	{
	}

	void GVersion::paint(Graphics *g)
	{
		int i, j, psNum = 0;
		MemoryInfo meminfo;
		PsInfo psinfo;
		
		// バージョンアイコン
		for (i = 0; i < 32; i++) {
			for (j = 0; j < 32; j++) {
				g->drawPixel(12 + j, 7 + i, versionIcon_palette[versionIcon_data[i * 32 + j]]);
			}
		}

		// 全起動プロセス数
		syscall_get_memory_info(&meminfo);
		syscall_set_ps_dump();
		while (syscall_read_ps_dump(&psinfo) == 0) {
			psNum++;
		}
		
		char mesg1[64], mesg2[64], mesg3[64], mesg4[64];
		sprintf(mesg1, "%dKB", meminfo.totalMemoryL / 1024, mesg1);
		sprintf(mesg2, "%dKB", meminfo.freePageNum * meminfo.pageSize / 1024, mesg2);
		sprintf(mesg3, "%dKB", meminfo.totalPageNum * meminfo.pageSize / 1024, mesg3);
		sprintf(mesg4, "%d個", psNum);

		g->setColor(0,0,0);
		g->drawString(BAYGUI_VERSION, 50, 10);
		g->drawString(BAYGUI_COPYING, 50, 26);
		g->setColor(96,96,96);
		g->drawRect(10,50,250,90);
		g->drawString("シェル 32bit / カーネル 32bit", 15, 55);
		g->drawString("全物理メモリ", 15, 71);
		g->drawString("有効ページプール", 15, 87);
		g->drawString("全ページプール", 15, 103);
		g->drawString("全起動プロセス数", 15, 119);
		g->drawString(mesg1, 156, 71);
		g->drawString(mesg2, 156, 87);
		g->drawString(mesg3, 156, 103);
		g->drawString(mesg4, 156, 119);
	}
};

/** メイン */
int MonaMain(List<char*>* pekoe)
{
	GVersion *version = new GVersion();
	version->run();
	return 0;
}
