/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#if !defined(_COMPONENT_H_INCLUDED_)
#define _COMPONENT_H_INCLUDED_

namespace baygui {
	class Container;

	/**
	 iNX
	 */
	class Component : public Object {
	private:
		/** ei */
		Container* parent;
		/** E񊈐 */
		bool enabled;
		/** tH[JXL */
		bool focused;
		/** \E\ */
		bool visible;
		/** xi΍Wj */
		int x;
		/** yi΍Wj */
		int y;
		/**  */
		int height;
		/**  */
		int width;
		/** wiF */
		dword backColor;
		/** OiF */
		dword foreColor;
		/** tHgX^C */
		int fontStyle;
		/** ȋ傫 */
		Rectangle bounds;
		/** `̈ */
		Graphics* _g;
		/** `obt@[ */
		Image* _buffer;
		/** tHg */
		FontMetrics* _metrics;

	protected:
		/** tH[JXCxg */
		Event focusEvent;

	public:
		/** RXgN^ */
		Component();
		
		/** fXgN^ */
		virtual ~Component();
		
		/**
		 inh.
		 removeNotify()ĂԂƍďłB
		 */
		virtual void addNotify();
		
		/**
		 ijnh.
		 addNotify()ĂԂƍďłB
		*/
		virtual void removeNotify();

		/** Cxgnh */
		virtual void processEvent(Event* event);
		
		/** `nh */
		virtual void paint(Graphics* g);
		
		/** Cxg */
		virtual void dispatchEvent(Event* event);
		
		/** ĕ` */
		virtual void repaint();
		
		/** iXV */
		virtual void update();
		
		/** iXV */
		virtual void update(int x, int y, int w, int h);
		
		/** ei𓾂 */
		inline Container* getParent() { return this->parent; }
		
		/** E񊈐𓾂 */
		inline bool getEnabled() { return this->enabled; }
		
		/** tH[JXԂ𓾂 */
		inline bool getFocused() { return this->focused; }
		
		/** \E\𓾂 */
		inline bool getVisible() { return this->visible; }
		
		/** XW𓾂 */
		inline int getX() { return this->x; }
		
		/** YW𓾂 */
		inline int getY() { return this->y; }
		
		/** 𓾂 */
		inline int getWidth() { return this->width; }
		
		/** 𓾂 */
		inline int getHeight() { return this->height; }
		
		/** ȋ傫 */
		inline Rectangle* getBounds() { return &this->bounds; }
		
		/** wiF𓾂 */
		inline dword getBackground() { return this->backColor; }
		
		/** OiF𓾂 */
		inline dword getForeground() { return this->foreColor; }
		
		/** tHgX^C𓾂 */
		inline int getFontStyle() { return this->fontStyle; }
		
		/** `IuWFNg𓾂 */
		virtual Graphics* getGraphics() { return this->_g; }
		
		/**
		 obt@[𓾂.
		 VRAM̂悤ɒڕ`悵ƂɗpB
		 GraphicsNXĂ悤ȕ֗ȃ\bh͂ȂB
		 `update()ĂԂƂŎۂ̕`悪B
		 */
		virtual Image* getBuffer() { return this->_buffer; }
		
		/** tHg𓾂 */
		inline FontMetrics* getFontMetrics() { return this->_metrics; }
		
		/**
		 CEBhE𓾂.
		 CEBhEƂ͑SĂ̕iĂԉ̃EBhEB
		 CEBhE͊eAvP[VƂɕKP݂ĂB
		 */
		virtual Component* getMainWindow();
		
		/**
		 Ԃݒ肷
		 @param enabled  (true / false)
		 */
		virtual void setEnabled(bool enabled);
		
		/**
		 tH[JXԂݒ肷.
		 ̃\bhĂԂƊYiFOCUS_IN܂FOCUS_OUTCxgB
		 @param focused tH[JX (true / false)
		 */
		virtual void setFocused(bool focused);
		
		/**
		 \Ԃݒ肷
		 @param visible \ (true / false)
		 */
		virtual void setVisible(bool visible);
		
		/**
		 傫ݒ肷
		 @param x xW
		 @param y yW
		 @param width 
		 @param height 
		*/
		virtual void setBounds(int x, int y, int width, int height);
		
		/**
		 ʒuύX
		 @param x XW
		 @param y YW
		*/
		virtual void setLocation(int x, int y);
		
		/**
		 eiݒ肷
		 @param parent ei
		*/
		virtual void setParent(Container* parent);
		
		/** wiFݒ肷 */
		virtual void setBackground(dword backColor);
		
		/** OiFݒ肷 */
		virtual void setForeground(dword foreColor);
		
		/**
		 tHgX^CiʏAAΎAŒ蕝jݒ肷.
		 eX^C"|"őgݍ킹邱Ƃ\B
		 @param style tHgX^C (Font::PLAIN / Font::BOLD / Font::ITALIC / Font::FIXED )
		*/
		virtual void setFontStyle(int style);
	};
}

#endif // _COMPONENT_H_INCLUDED_
