/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef _STRING_H_INCLUDED_
#define _STRING_H_INCLUDED_

#include "Object.h"

namespace baygui {
	/** NX */
	class String : public Object {
	protected:
		/**  */
		char* buffer;
		/**  */
		int _len;

	public:
		/** ftHgRXgN^ */
		String();
		
		/**
		 Rs[RXgN^
		 @param text 
		 @param length 񒷁il^ꂽ̒j
		*/
		String(const char* text, int length = -1);
		
		/**
		 Rs[RXgN^
		 @param text 
		*/
		String(const String& text);
		
		/** fXgN^ */
		virtual ~String();
		
		/** 'const char*'Zq */
		operator const char*() const { return this->buffer; }
		
		/** '='Zq */
		String& operator =(const char* text);
		
		/** '='Zq */
		String& operator =(const String& text);
		
		/** '+='Zq */
		void operator +=(const char* text);
		
		/** '+='Zq */
		void operator +=(const String& text);
		
		/** '+='Zq */
		void operator +=(char ch);
		
		/** '+'Zq */
		String operator +(const char* text) const;
		
		/** '+'Zq */
		String operator +(const String& text) const;
		
		/** 𓾂 */
		char* getBytes() const { return this->buffer; }
		
		/** Ch̒𓾂 */
		int length() const;
		
		/** w肳ꂽԂ̃Ch𓾂 */
		unsigned int charAt(int index) const;
		
		/** Ch𓾂 */
		const unsigned int* toCharArray() const;
		
		/**
		 w肳ꂽIuWFNgƓǂ𓾂
		 @param obj rΏۂ̃IuWFNg
		*/
		virtual bool equals(Object* obj) const { return equals((String *)obj); }
		
		/**
		 w肳ꂽƓǂ𓾂
		 @param value 
		*/
		bool equals(const String& value) const;
		
		/**
		 w肳ꂽŎn܂Ă邩ǂ𓾂
		 @param value 
		*/
		bool startsWith(const String& value) const;
		
		/**
		 w肳ꂽŏIĂ邩ǂ𓾂
		 @param value 
		*/
		bool endsWith(const String& value) const;
		
		/**
		 w肳ꂽo擪̈ʒu𓾂
		 @param ch 
		 @param from Jnʒu
		*/
		int indexOf(char ch, int from = 0) const;
		
		/**
		 w肳ꂽ񂪏o擪̈ʒu𓾂
		 @param value 
		 @param from Jnʒu
		*/
		int indexOf(const String& value, int from = 0) const;
		
		/**
		 w肳ꂽoI[̈ʒu𓾂
		 @param ch 
		 @param from Jnʒu
		*/
		int lastIndexOf(char ch, int from = -1) const;
		
		/**
		 w肳ꂽ񂪏oI[̈ʒu𓾂
		 @param value 
		 @param from Jnʒu
		*/
		int lastIndexOf(const String& value, int from = -1) const;
		
		/**
		 𓾂
		 @param start Jnʒu
		 @param length 
		*/
		String substring(int start, int length) const;
		
		/** ׂĂ̕ɕϊ */
		String toLowerCase() const;
		
		/** ׂĂ̕啶ɕϊ */
		String toUpperCase() const;
	};
}

extern baygui::String operator +(const char* text1, const baygui::String& text2);

#endif  // _STRING_H_INCLUDED_
