/*!
    \file  SocketsManager.h
    \brief SocketQ ǗNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami 
    \version $Revision: 1.1 $
    \date   create:2005/07/15 update:$Date: 2005/07/22 08:40:09 $
*/
#ifndef _MONA_SOCKETSMANAGER_
#define _MONA_SOCKETSMANAGER_

#include <sys/types.h>
#include <sys/HashMap.h>
#include <monapi.h>

#include "Socket.h"

/* TCP ԑJ */
#define     CLOSED      0
#define     LISTEN      0
#define     SYN_RCVD    1
#define     SYN_SENT    1
#define     ESTABLISHED 2
#define     FIN_WAIT_1  4
#define     CLOSE_WAIT  4
#define     LAST_ACK    4
#define     FIN_WAIT_2  5
//#define       TIME_WAIT       6


#define MAX_SOC_SIZE    1024    //őRlNV  

/*!
    SocketsManager class
*/
class SocketsManager
{
    
  public:
    
    //RXgN^
    SocketsManager();
    ~SocketsManager();
    
    Socket* findSocket(dword ip ,word  myport ,word youport);
    void registLisSocket(dword tid ,word  myport );
    void registConSocket(dword tid ,word myport, dword ip , word youport);

  private:
    //RlNVSocketnbV
    HashMap<Socket*> *conSocHash;
    
    //XSocketnbV
    HashMap<Socket*> *lisSocHash;

};

#endif
