/**
	@file	CollectionArrayInline.h
	@brief	RNV Iz

	RNV Iz

	License=Mona License
	@version $Revision: 1.1 $
	@date	$Date: 2005/09/05 15:00:18 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_COLLECTIONARRAYINLINE_H
#define _MONAPI2_BASIC_COLLECTIONARRAYINLINE_H

#include "Search.h"
#include "Math.h"

namespace monapi2	{

//Array//////////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
Array<TYPE>::Array(uint nItitialSize)
{
	init(nItitialSize);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::init(uint nItitialSize)
{
	m_nCount		= 0;
	m_nSize	= nItitialSize;
	m_apData		= NULL;

	getNewSize(nItitialSize);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
Array<TYPE>::~Array()
{
	removeAll();
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::deleteOldBuffer(TYPE* pBuffer,uint )	//͎̌pNXŎgBł̓_~[B
{
	delete[] pBuffer;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
TYPE Array<TYPE>::getAt(uint n) const
{
	if (n>=m_nCount)	return 0;

	return m_apData[n];
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::add(TYPE t)
{
	m_nCount++;

	TYPE* pOldBuffer = extendBuffer(m_nCount);

//obt@̕ϓB
	if (pOldBuffer)
	{
//O̗vfړB
		for (uint n=0;n<m_nCount-1;n++)
		{
			m_apData[n] = pOldBuffer[n];
		}
//f[^폜ł͂ȂړȂ̂ŃTCYw0ɂĂB
		deleteOldBuffer(pOldBuffer,0);
	}

	m_apData[m_nCount-1] = t;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
TYPE* Array<TYPE>::extendBuffer(uint nSize)
{
//vȏ̗̈łɎĂ̂ŉȂłB
	if (nSize <= m_nSize)	return NULL;

	uint nNewSize = m_nSize;
	if (nNewSize == 0)	nNewSize =1;

//傫͔{X
	while (nNewSize < nSize)
		nNewSize*=2;

//obt@mہB
	return getNewSize(nNewSize);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
bool Array<TYPE>::setAt(uint nIndex,TYPE tValue)
{
	if (nIndex>=getCount())	return false;

	m_nCount=getMax(m_nCount,nIndex);
	m_apData[nIndex] = tValue;
	return true;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
bool Array<TYPE>::insertAt(uint nIndex,uint nCount)
{
	if (nIndex>=getCount())	return false;

	uint nOldCount = m_nCount;
	m_nCount+=nCount;

	uint nOldSize = getSize();
//obt@̊g݂B(\ɂꍇ͉NȂB)
	TYPE* pOldBuffer = extendBuffer(m_nCount);

	uint n;
//obt@̕ϓB
	if (pOldBuffer)
	{
//}CfbNXO̗vfB
		for (n=0;n<nIndex;n++)
		{
			m_apData[n] = pOldBuffer[n];
		}
	}

//}CfbNX̗vfړB
	for (n=nIndex+nCount;n<nOldCount+nCount;n++)
	{
		m_apData[n] = m_apData[n-nCount];
	}

//}ꂽꏊ͋ɂĂBiÕf[^cĂdeleteƃ}YBj
	for (n=nIndex;n<nIndex+nCount;n++)
	{
		m_apData[n] = 0;
	}

	if (pOldBuffer)
	{
		deleteOldBuffer(pOldBuffer,nOldSize);
	}

	return true;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::setSize(uint nSize)
{
	uint nOldCount = getCount();
	TYPE* pOldBuffer = getNewSize(nSize);
	m_nCount=nSize;

//obt@̕ϓB
	if (pOldBuffer)
	{
//O̗vfړB
		for (uint n=0;n<nOldCount;n++)
		{
			m_apData[n] = pOldBuffer[n];
		}
//폜ł͂ȂړȂ̂ŃTCY0B
		deleteOldBuffer(pOldBuffer,0);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
TYPE* Array<TYPE>::getNewSize(uint nSize)
{
	if (nSize==0)	return NULL;

//obt@mہB
	TYPE* apNewData = new TYPE[nSize];
	for (uint n=0;n<nSize;n++)
	{
		apNewData[n]=0;
	}
	m_nSize = nSize;

	TYPE* pOldBuffer = m_apData;
	m_apData = apNewData;
	return pOldBuffer;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::sort(FnCompare pFnCompare)
{
	quicksort(m_apData,m_nCount,sizeof(TYPE),pFnCompare);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
bool Array<TYPE>::removeAt(uint nIndex,uint nCount)
{
	if (nIndex+nCount>=getCount())	return false;

//CfbNX̗vfړB
	for (uint n=nIndex+nCount;n<getCount();n++)
	{
		m_apData[n-nCount] = m_apData[n];
	}

	m_nCount-=nCount;

	return true;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void Array<TYPE>::removeAll()
{
//Size͊mۂĂĂobt@Ƃ͌Ȃ̂łgetSizeł͂ȂgetCountŐB
	deleteOldBuffer(m_apData,getCount());

	init(0);
}


//ArrayAD///////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
ArrayAD<TYPE>::~ArrayAD()
{
	Array<TYPE>::removeAll();
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
void ArrayAD<TYPE>::deleteOldBuffer(TYPE* pBuffer,uint nSize)
{
	for (uint n=0;n<nSize;n++)
		delete pBuffer[n];
	delete pBuffer;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
bool ArrayAD<TYPE>::setAt(uint nIndex,TYPE tValue)
{
	if (nIndex>=Array<TYPE>::getCount())	return false;

	Array<TYPE>::m_nCount = getMax(Array<TYPE>::m_nCount,nIndex);
	delete Array<TYPE>::m_apData[nIndex];
	Array<TYPE>::m_apData[nIndex] = tValue;
	return true;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
bool ArrayAD<TYPE>::removeAt(uint nIndex,uint nCount)
{
	if (nIndex+nCount>=Array<TYPE>::getCount())	return false;

//͈͂폜
	for (uint n=nIndex;n<nIndex + nCount;n++)
	{
		delete Array<TYPE>::m_apData[n];
	}

	return Array<TYPE>::removeAt(nIndex,nCount);
}


} //namespace monapi2

#endif
