/**
	@file	LanguageOther.cpp
	@brief	ER[hc[

	ER[hc[

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/09/11 11:54:00 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "LanguageOther.h"
#include "StringFn.h"
#include "FileFn.h"
#include "StringOther.h"

#ifdef GENERATE_CONVERSION_CODE
	#include "../MultiMedia/Bitmap.h"
#endif

namespace monapi2
{

#ifdef GENERATE_CONVERSION_CODE

/**
	@brief	.hQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool CGenerateConversionCode::generate(cpchar1 cszConversionTableFilePath,cpchar1 cszPathOut)
{
//t@Cǂ
	String strFileContent;
	if (! FileFn::read(cszConversionTableFilePath,&strFileContent)) return false;

//sɕ
	StringDivide SDLine(strFileContent,"\n");

	int i;
//ϊe[u̗p
	for (i=0;i<0xFFFF;i++)	
	{
		m_aIntPair[i].m_i1=i;
		m_aIntPair[i].m_i2=0;
	}

//Ss
	for (int iLine=0;iLine<SDLine.getCount();iLine++)
	{
//^uŕ
		StringDivide Sdword(SDLine.getAt(iLine),"	");

//ŏ̓R[h1
		cpchar1 cszCode1= Sdword.getAt(0);
		int iCode1	=StringFn::toInt(cszCode1+2,16);

//Lł͂ȂsB
		if (cszCode1[0] != '0') continue;		//s0xŎn܂̂

//̓R[h2
		cpchar1 cszCode2 = Sdword.getAt(1);
		int iCode2;

//`ĂȂꏊɂ͋󔒂ĂB͖B		
		if (cszCode2[0] != ' ')		iCode2=StringFn::toInt(cszCode2+2,16);
		else						iCode2=0;

//ϊe[uɓB
		ASSERT(iCode1<0xFFFF);
		m_aIntPair[iCode1].m_i2 = iCode2;
	}

//ϊ\FɒBitmapɂBđ啝Ȑ헪B
//	dumpBMP();return false;

//ŏIIɓfoSR[h
	String strCodeWhole;

//wb_[
	strCodeWhole=
		"/**\n"
		"	@file	Language2.cpp\n"
		"	@brief	class CGenerateConversionCodeŎ쐬ꂽShiftJISUnicodeϊC++t@C\n"
		"\n"
		"	class CGenerateConversionCodeŎ쐬ꂽShiftJISUnicodeϊC++t@C\n"
		"\n"
		"	License=Mona License\n"
		"	@version $Revision: 1.2 $\n"
		"	@date	$Date: 2005/09/11 11:54:00 $\n"
		"*/\n"
		"\n"
		"#include \"Language.h\"\n"
		"\n"
		"namespace monapi2	{\n"
		"\n"
		"//̃t@C̓RpCɎԂ̂Ŏۂ͂ȂBɃf[^t@CƂēǂݏoB\n"
		"#if 0\n\n";


//12̕ϊe[u
	generateCCode(0,&strCodeWhole);

//R[h12
	for (i=0;i<0xFFFF;i++)
	{
		int iI2Copy=m_aIntPair[i].m_i2;
		m_aIntPair[i].m_i2=m_aIntPair[i].m_i1;
		m_aIntPair[i].m_i1=iI2Copy;
	}
//()R[h2ŕёւ
	quicksort(m_aIntPair,0xFFFF,sizeof(CIntPair),compareByCode1);

//21̕ϊe[u
	generateCCode(1,&strCodeWhole);

//tb^[
	strCodeWhole+="\n\n#endif	//#if 0\n\n}	//namespace monapi2\n";

//o
	FileFn::write(cszPathOut,&strCodeWhole);

	return true;
}

/**
	@brief	.hQƁB
	@date	2005/08/20	junjunn 쐬
*/
void CGenerateConversionCode::dumpBMP()
{
	Bitmap bitmap;
	bitmap.getCanvas(0x100,0x100);

//^ɓhԂB
	bitmap.fill(0);

	for (int i=0x0;i<0xFFFF;i++)
	{
		int iCode1=m_aIntPair[i].m_i1;
		int iCode2=m_aIntPair[i].m_i2;

		if (iCode2>0)
		{
			colort color=(0x00FF0000+(iCode2));
			bitmap.setPixel(((iCode1&0xFF00)>>8),iCode1&0xFF,color);
		}
	}

	bitmap.write("test.bmp");
}

/**
	@brief	.hQƁB
	@date	2005/08/20	junjunn 쐬
*/
void CGenerateConversionCode::generateCCode(int i1to2,String* pstrOut)
{
	CConversionRule* pConversionRule = &m_ConversionRule2Way.m_aConversionRule[i1to2];

//̃e[uɕď
	{
		pstrOut->formatJoinSelf(
			"int LanguageFn::convert%s(byte x,byte y)\n"
			"{\n",
			pConversionRule->m_strName.getString());


		char szTemp[256];
//SĂ̗̈
		for (int i=0;;i++)
		{
			Rect* pRect = &pConversionRule->m_parectConversion[i];
			if (pRect->getLeft() < 0)	break;	//ԕ

			StringFn::format(szTemp,
				"	if (0x%2X<=x&&x<0x%2X && 0x%2X<=y&&y<0x%2X)\n	{\n",
				pRect->getLeft(),pRect->getRight(),pRect->getTop(),pRect->getBottom());
			*pstrOut +=	szTemp;

			char szTableName[100];
			getCGenerateConversionCodeTableName(szTableName,pConversionRule,i);

			StringFn::format(szTemp,"		vchar %s[]={\n			",szTableName);
			*pstrOut +=	szTemp;

			int iElementOutCount=0;	//R[h2foB
			for (int x=pRect->getLeft();x<pRect->getRight();x++)
			{
				for (int y=pRect->getTop();y<pRect->getBottom();y++)
				{
					int iCode2=m_aIntPair[y + 0x100*x].m_i2;
					StringFn::format(szTemp,"0x%4X,",iCode2);
					(*pstrOut) +=	szTemp;

//萔ŉs܂ł
					if (++iElementOutCount==8)
					{
						(*pstrOut)+="\n";
						if (x!=pRect->getRight()-1 || y!=pRect->getBottom()-1)	//ŌザȂȂ
						{
							StringFn::format(szTemp,"			");
							(*pstrOut)+=szTemp;
							iElementOutCount=0;
						}
					}
				}
			}

			StringFn::format(szTemp,
				"		};\n"
				"		return %s[(y-0x%2X) + 0x%2X*(x-0x%2X)];\n	}\n\n",
				szTableName,pRect->getLeft(),pRect->getHeight(),pRect->getTop());
			(*pstrOut) +=	szTemp;
		}
	}

	*pstrOut +=
		"	return 0;\n"
		"}\n";
}

/**
	@brief	.hQƁB
	@date	2005/08/20	junjunn 쐬
*/
int CGenerateConversionCode::compareByCode1(const void* p,const void* q)
{
	CIntPair* pIntPairP=(CIntPair*)p;
	CIntPair* pIntPairQ=(CIntPair*)q;

	return pIntPairP->m_i1-pIntPairQ->m_i1;
}

#endif //#ifdef GENERATE_CONVERSION_CODE

}	//namespace monapi2
