/**
	@file	Math.h
	@brief	w֘A

	w֘A

	License=Mona License
	@version $Revision: 1.5 $
	@date	$Date: 2005/09/11 11:54:00 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_MATH_H
#define _MONAPI2_BASIC_MATH_H

#include "switch.h"
#include "Type.h"
#include "Limit.h"

namespace monapi2	{

/**
	@brief	wBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/

const double PI		=	3.14159265358979323846;		///<~
#ifndef NAPIER
const double NAPIER	=	2.71828182845904523536;		///<Rΐ̒
#endif
#ifndef HUGE_VAL
const double HUGE_VAL	=	_DOUBLE_MAX;				///<expȂǂŌvZłől𒴂ƂɏoĂB
#endif

//lZB
void divide(int iNumerator,int iDenominator,int* piQuotient,int* piRemainder);
void divide(double dNumerator,double dDenominator,int* piQuotient,double* pdRemainder);

//w
double power(double x, double y);
uint power(uint x, uint y);
double power2(double x);
double squareroot(double num);
double log(double x);

#undef log2		  	 	 	//ꕔ̊łlog2̃}N`ĂďՓ˂̂ŁB 
double log2(double x);

double log10(double x);
double exponential(double x);

//Op֐
double sin(double angle);
double cos(double angle);
double tan(double angle);
double atan(double x,double y);
double atan(double x);
double acos(double x);
double asin(double x);

//؂グE؂̂āEľܓEΒlȂǕό`␮`
int		mod(int iTarget,int iModule);
double	mod(double iTarget,double dModule);
double	ceil(double x);
double	floor(double x);
double	round(double x);
inline int		absolute(int i)		{return (i>0)?i:-i;}
inline double	absolute(double d)	{return (d>0)?d:-d;}

//
void initRandom(int iSeed);
int getRandom(uint nRange);

//̑
float convertLinearUnit(float fTarget,float fValue1From,float fValue1To,float fValue2From,float fValue2To);
inline void swap(int* pi1,int* pi2)	{int iTemp=*pi1;*pi1=*pi2;*pi2=iTemp;}

inline int getMin(int i1,int i2)					{return (i1<i2)?i1:i2;}
inline int getMin(uint i1,uint i2)					{return (i1<i2)?i1:i2;}
inline cpchar1 getMin(cpchar1 p1,cpchar1 p2)		{return (p1<p2)?p1:p2;}

inline int getMax(int i1,int i2)					{return (i1>i2)?i1:i2;}
inline int getMax(uint i1,uint i2)					{return (i1>i2)?i1:i2;}
inline cpchar1 getMax(cpchar1 p1,cpchar1 p2)		{return (p1>p2)?p1:p2;}

void putBetween(int* piTarget,int iMin,int iMax);

//dTarget = dModule * q + r;̌`ɂB
//rdModule/2菬Ȃ悤Ɂi\Ȍ]̐ΒlȂjq1₷炵ĒB
void getModule_ReduceRemainder(double dTarget,double udModule,int* piQuotient,double* piRemainder);


/**
	@brief	2^()vZ邽߂̃Tu[`
	@date	2005/08/20	junjunn 쐬
*/
class SCPowerOf2
{
public:
//2^xvZBSĂxB
	static double get(double x);

protected:
public:
//2^xvZB-1<x<1
	static double getFloat(double x);
//2^xvZBx͐ɐ؂̂ĂB
	static double getInt(double x);
};


/**
	@brief	_B
	@date	2005/08/20	junjunn 쐬
*/
//ǂ̗]n肻EEE
class KnuthRandom
{
public:
	KnuthRandom();

	void init(long lSeed);	///<
	void randomize();		///<_

	long getInt();			///< 0 <= x < iRANDOM_RANGE ̊ԂlongԂ
	double getFloat();		///< 0 <= x < 1 ̊ԂdoubleԂ

	float getRange()	{return m_fRange;}


protected:
	enum {
		iTABLE_SIZE =55,
		iTABLE_MID_SIZE =24,
		iTABLE_SEED	= 21,
		iRANDOM_RANGE = _INT_MAX,	//0`͈̔͂ŐlB
	};

	int m_iCurPos;
	float m_fRange;
	long m_aiBuffer[iTABLE_SIZE+1];
};

}	//namespace monapi2

#endif
