/**
	@file	Search.cpp
	@brief	\[gET

	\[gET

	License=Mona License
	@version $Revision: 1.1 $
	@date	$Date: 2005/09/05 15:00:18 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Search.h"
#include "CollectionList.h"

namespace monapi2
{

//QuickSort̃IvVBptH[}X̂߂ŕʂdefineĂقΑȂB
#define QSORTOPTION_SMARTPIVOT
#define QSORTOPTION_PRESORTCHECK


/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void quicksort(void* pavArray,uint iArrayMemberCount,uint nArrayMemberWidth,FnQSortCompare pfnCompare)
{
	CQuickSort QuickSort;
	QuickSort.Sort(pavArray,0,iArrayMemberCount,nArrayMemberWidth,pfnCompare);
}


//CQuickSort/////////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void CQuickSort::Sort(void* pavArray,int iStart,int iCount,uint nArrayMemberWidth,FnQSortCompare pfnCompare)
{
//`[pɎԂv
#ifdef _PERFORMANCETEST
	DWORD dwTickStart = GetTickCount();
#endif

	m_iStart	= iStart;
	m_iCount	= iCount;
	m_pavArray	= pavArray;
	m_nArrayMemberWidth = nArrayMemberWidth;
	m_pfnCompare= pfnCompare;

//łɃ\[gĂ邩`FbN
#ifdef QSORTOPTION_PRESORTCHECK
	if (isSorted())
	{
#ifdef _PERFORMANCETEST
		m_nTimeTaken = GetTickCount() - dwTickStart;
#endif
		return;
	}
#endif

	m_pSwapBuffer = new char[m_nArrayMemberWidth];

	int iLeft = iStart;
	int iRight = iStart+iCount-1;


	Stack<int> stack;

//QuickSortɂ͍ċA菜X^bNŎo[WgB
//ċAǂOSIɎsX^bNȂ̂
//ċAIɌĂяo@肩͂ăvOŎŃX^bN1֐ɔ[߂
//Xs[hIɂIɂLŌ悭`[AbvłB
	for (;;)
	{
		while (iRight>iLeft)
		{
//sIiPivot荶͑SpavArray[iPivot]<=ŁAE͑S>=ȗvfԂ悤\[gĂB
			int iPivot = Partition(iLeft,iRight);

//Eƍ̂ǂ炪vfrB
			if (iPivot-iLeft > iRight-iPivot)
			{
				stack.push(iLeft);
				stack.push(iPivot-1);
				iLeft=iPivot+1;
			}
			else
			{
				stack.push(iPivot+1);
				stack.push(iRight);
				iRight=iPivot-1;
			}
		}

		if (stack.isEmpty()) break;
		iRight=stack.pop();
		iLeft=stack.pop();
	}

	delete m_pSwapBuffer;

#ifdef _PERFORMANCETEST
	m_nTimeTaken = GetTickCount() - dwTickStart;
#endif


//\[gsꂽZ
#ifdef _DEBUG
//	assert(IsSorted());
#endif

}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int CQuickSort::Partition(int iLeft,int iRight)
{
//X}[gs{bg
#ifdef QSORTOPTION_SMARTPIVOT
/*
ςȘbQuickSort͂炩߃\[gĂf[^芮SɃ_ȃf[^̃\[g̕
ꡂɑB
iQuickSort̓s{bgŃf[^܂2ꂽ݂̔r񐔂čō̃Xs[hoB
@炩߃\[gĂf[^͂傤ǂ̋tŕSȂňɒxȂBj
̍ňP[XׂɂƂёւsĂB

̓Iɂ͂܂ŏAŌAԂ3̒l璆lTos{bgɗpB
i[̐s{bgɂȂ̂ňȂ̂ŁjB
*/
	int iMiddle = (iLeft+iRight)/2;
//s{bgTāAłɕёւsĂB
	sortTriplet(iLeft,iMiddle,iRight);

//^񒆂̒liRight-1ɎĂăs{bgƂėpB
	swap(iMiddle,iRight-1);

//łSortTripletōE[͒lɑ΂\[gĂ鎖킩Ă̂Ŕ͈͂߂Ă
	iRight--;
	iLeft++;
#endif

//PartitioñC
	void* pvPivot= getElementAddress(iRight);
	int iSwapLeft=iLeft-1;
	int iSwapRight=iRight;

#ifdef QSORTOPTION_SMARTPIVOT
	if (iSwapLeft>=iSwapRight)	return iSwapLeft;
	if (iRight==0)				return iSwapLeft;
#endif

	for(;;)
	{
		while (compare(getElementAddress(++iSwapLeft)	,pvPivot)<0);	//ňpvPivotŎ~܂̂while[v͖ȂB
		while (compare(getElementAddress(--iSwapRight)	,pvPivot)>0);	//ňpvPivotŎ~܂̂ŖȂB
		if (iSwapLeft>=iSwapRight)	break;
		swap(iSwapLeft,iSwapRight);
	}

	swap(iSwapLeft,iRight);

	return iSwapLeft;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void CQuickSort::swap(int i1,int i2)
{
	set(m_pSwapBuffer,getElementAddress(i1));
	set(getElementAddress(i1),getElementAddress(i2));
	set(getElementAddress(i2),m_pSwapBuffer);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void CQuickSort::sortTriplet(int iLeft,int iMiddle,int iRight)
{
	if (isSwapRequired(getElementAddress(iLeft),getElementAddress(iMiddle)))	swap(iLeft,iMiddle);
	if (isSwapRequired(getElementAddress(iLeft),getElementAddress(iRight)))		swap(iLeft,iRight);
	if (isSwapRequired(getElementAddress(iMiddle),getElementAddress(iRight)))	swap(iMiddle,iRight);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool CQuickSort::isSorted()
{
	for (int i=m_iStart;i<m_iStart+m_iCount-1;i++)
	{
		if (isSwapRequired(getElementAddress(i),getElementAddress(i+1)))
			return false;
	}
	return true;
}

/*
void CQuickSort::SmallSort(int iStart,int iCount)
{
	InsertionSort(iStart,iCount);
}

void CQuickSort::InsertionSort(int iStart,int iCount)
{
	for (int i=iStart;i<iStart+iCount;i++)
	{
		void* pvPivot=getElementAddress(i);
		int j=i;
		while (isSwapRequired(getElementAddress(j-1),pvPivot) && j>=iStart)	//@todo ԕgȂǂł͌ł邩B
		{
			set(getElementAddress(j),getElementAddress(j-1));
			j--;
		}

		set(getElementAddress(j),pvPivot);
	}
}
*/

///̑/////////////
#ifdef _PERFORMANCETEST
/**
	@brief	x𑪂B
	@date	2005/08/20	junjunn 쐬
*/
void TestQSort()
{
//inteXg
	{
		int iTestCount = 100000;	//\[gvf

		UINT nTimeRandom;			//S_\[ĝɂ鎞
		UINT nTimeSorted;			//łɊSɃ\[gĂ̂ɂx\[g炩鎞
		UINT nTimeSortedReverse;	//łɊSɋt\[gĂ̂\[gɂ鎞
		UINT nTimeSortedAlmost;	//قڊSɃ\[gAꕔɔ\[gĂf[^\[ĝɂ鎞

		CQuickSort QuickSort;
		srand(time(NULL));

		int* paiArray = new int[iTestCount];

		for (int i=0;i<iTestCount;i++)		paiArray[i] = SCMath::GetRandom(iTestCount);
		QuickSort.Sort(paiArray,0,iTestCount,sizeof(int),CompareInt);
		nTimeRandom = QuickSort.m_nTimeTaken;

		for (i=0;i<iTestCount;i++)		paiArray[i] = i;
		QuickSort.Sort(paiArray,0,iTestCount,sizeof(int),CompareInt);
		nTimeSorted = QuickSort.m_nTimeTaken;

		for (i=0;i<iTestCount;i++)		paiArray[i] = iTestCount-i;
		QuickSort.Sort(paiArray,0,iTestCount,sizeof(int),CompareInt);
		nTimeSortedReverse = QuickSort.m_nTimeTaken;

		for (i=0;i<iTestCount;i++)		paiArray[i] = i;
		for (i=1;i<=4;i++)	paiArray[SCMath::GetRandom(iTestCount)] = iTestCount / 5 * (i);
		QuickSort.Sort(paiArray,0,iTestCount,sizeof(int),CompareInt);
		nTimeSortedAlmost = QuickSort.m_nTimeTaken;

		delete paiArray;

		::CString strReport;
		strReport.Format("Random-	%d\nSorted-	%d\nSortedReverse-	%d\nSortedAlmost-	%d",nTimeRandom ,nTimeSorted ,nTimeSortedReverse ,nTimeSortedAlmost);
		SCWinFile::Dump((PCSTR1)(PCSSTR1)strReport);


		int aiArray[]={1,5,3,9,7,2,6,10,4,8};
		QuickSort.Sort(aiArray,0,10,sizeof(int),CompareInt);

/*
ʁB

iTestCount = 100000̃\[gɂTick(CPUFAthlon64 3000+)B
ꂼ̎3sςĂB
WindowsTick\̈Ŋelɍő20炢̌덷oĂۂ
Dׂx͂͂oĂ̂(߃)ƼŲ

X^bNE~X}[gs{bgE~\[g`FbNE~SmallSort
	Random-	141
	Sorted-	48625
	SortedReverse-	48472
	SortedAlmost-	31563
炩߃\[gĂf[^ɑ΂Ă̓Az݂ɐ\EEE


X^bNEX}[gs{bgE~\[g`FbNE~SmallSort
	Random-	125
	Sorted-	83
	SortedReverse-	78
	SortedAlmost-	67
\[gf[^nɈ|IȉPB


X^bNEX}[gs{bgE\[g`FbNE~SmallSort
	Random-	125
	Sorted-	0
	SortedReverse-	99
	SortedAlmost-	67
SortedReverseSorted0ɁB
SortedReverseg@͏Ȃ낤Sorted̃bgɑ΂̃XN͍̎ZƎvB
Random͈̎uŃ\[g`FbNÎŃI[o[wbhȂƎvB


ȂintɌpFnComparȇɒ< >r𖄂ߍŃ\[g
͈ȉ̒ʂɂȂB
X^bNE~X}[gs{bgE~\[g`FbNE~SmallSort
	Random-	62
X^bNEX}[gs{bgE~\[g`FbNE~SmallSort
	Random-	63
X^bNEX}[gs{bgE\[g`FbNE~SmallSort
  	Random-	62

S̓Iɔ{炢ȂB
RƌΓRintȂǂ̒Pf[^^ɂqsortł͂Ȃ
ꂼɍœK\[gpӂĂƍɂȂB


@Memo QuickSortP
܂SmallSort͖CvgB
œK͋ÂoƃLȂ̂ő̍Ƃ邵͂Ő؂グB
*/
	}

//eXg
	{
		srand(time(NULL));
		int iTestCharCount = 10;
		char** paszArray = new char*[iTestCharCount];

		for (int i=0;i<iTestCharCount;i++)
		{
			paszArray[i] = new char[11];
			for (int j=0;j<10;j++)
			{
				paszArray[i][j] = (char)('a' + SCMath::GetRandom(26));
			}
			paszArray[i][10] = '\0';
		}

		CQuickSort QuickSort;
		QuickSort.Sort(paszArray,0,iTestCharCount,sizeof(char*),CompareString);

		for (i=0;i<iTestCharCount;i++)	{delete paszArray[i];}
		delete paszArray;


		char* aszArray[]={"Zonu","Mona","Nida","Sii","Morara","Giko","Siraneeyo",};
		QuickSort.Sort(aszArray,0,7,sizeof(char*),CompareString);
	}
}
#endif


}	//namespace monapi2
