/**
	@file	Bitmap.cpp
	@brief		rbg}bv̎舵EB

	rbg}bv̎舵EB

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/11/22 05:56:33 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Bitmap.h"
#include "../Basic/File.h"
#include "../Basic/Debug.h"
#include "../Basic/Memory.h"

namespace monapi2	{

#define ASSERT_PIXEL(x,y)	ASSERT(x>=0 && x<m_iWidth && y>=0 && y<m_iHeight);

	
	

//.bmpt@C̋KiBÂKîߍgĂȂoSɗȂo
//ł͂.bmp`ɓK͂ȂBgȂo͑SB
//ߋׂ݊̈̃t@Co͂ɎgB

/**
rbg}bvɂĂ̏B

	@date	2005/08/20	junjunn 쐬
*/
class BitmapInfoHeader
{
public:
	void set(const byte* p)
	{
		m_iWidth	=*(dword*)(p+0x04);
		m_iHeight	=*(dword*)(p+0x08);
		m_wBitFormat=*(word*) (p+0x0E);
	}


public:
//	dword	m_dwSizeStructure;		///<̍\̂̃TCYBӖo[WɎgB
	int		m_iWidth;				///<BuintȂintȂ̂̓}CiXlƏ㉺]BMP𐶐ӖƂlB
	int		m_iHeight;				///<B
//	word	m_wPlanes;				///<sgpB1B
	word	m_wBitFormat;			///<rbgtH[}bgB1,4,8,16,24,32ȂǂB
//	dword	m_dwCompression;		///<k@Bʂ͕sgpB
//	dword	m_dwSize;				///<C[W̃TCYBkĂƂ̉𓀌̑傫Ɏgʂ͕sgpB
//	long	m_lXPelsPerMeter;		///<𑜓xBʂ͕sgpB
//	long	m_lYPelsPerMeter;		///<𑜓xBʂ͕sgpB
//	dword	m_dwClrUsed;			///<ۂɎgĂFBʂ͕sgpB
//	dword	m_dwClrImportant;		///<dvȐFBʂ͕sgpB
}; 

//FwBpbgɎgB
/**
	@date	2005/08/20	junjunn 쐬
*/
struct RGBQuad
{
	byte	r; 
	byte	g; 
	byte	b;
	byte	m_byReserved; 
}; 

//rbg}bv+pbgf[^B24rbgȂpbgȂ̂Ńpbgf[^͖B
/**
	@date	2005/08/20	junjunn 쐬
*/
struct BitmapInfo
{
	BitmapInfoHeader	m_BitmapInfoHeader;
	RGBQuad*			m_RGBQuad;	//rbg}bv̐FrbgɉĕKvȕIɊmۂB
};

//rbg}bvt@Cwb_[B
/**
	@date	2005/08/20	junjunn 쐬
*/
struct BitmapFileHeader
{
public:
	void set(const byte* p)	
	{
		m_dwSize		=*(dword*)(p+0x02);
		m_dwOffsetToData=*(dword*)(p+0x0A);
	}
	int getDataSize()	{return m_dwSize-m_dwOffsetToData;};		//f[^{̂̑傫B

public:
//	word	m_wType;			///<t@C^CvʁB"BM"B
	dword	m_dwSize;			///<t@C̑傫B
//	word	m_wReserved1;		///<sgpB
//	word	m_wReserved2;		///<sgpB
	dword	m_dwOffsetToData;	///<t@C擪f[^{̂܂ł̃rbgB
}; 


//Bitmap/////////////////
/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::init()
{
	m_iWidth	= 0;
	m_iHeight	= 0;

	m_strPath.empty();
	m_bufferData.clear();

	m_strPath = "Bitmap.bmp";
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::clear()
{
	init();
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
byte* Bitmap::getCanvas(int iWidth,int iHeight)
{
	return getNewBuffer(iWidth,iHeight);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
byte* Bitmap::getNewBuffer(int iWidth,int iHeight)
{
	clear();

	m_iWidth	= iWidth;
	m_iHeight	= iHeight;
	setLineBits();

	return m_bufferData.extendBuffer(m_iLineSize * iHeight);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::setLineBits()
{
	m_iLineSize = getBMPLineSize(m_iWidth);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::copy(const Bitmap* cpBitmap)
{
	if (! cpBitmap->isValid())	return;

	clear();

	m_iWidth	= cpBitmap->m_iWidth;
	m_iHeight	= cpBitmap->m_iHeight;
	m_bufferData.copy(&cpBitmap->m_bufferData);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
byte* Bitmap::getPixelBuffer(int x,int y)
{
//擪\B
	if (x<0)	return m_bufferData.getBuffer();

	int iOffset = (m_iHeight - y - 1)*m_iLineSize + x*3;
	return m_bufferData.getBuffer() + iOffset;
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
colort Bitmap::getPixel(int x,int y)
{
	const byte* cpBaseByte = getPixelBufferConst(x,y);
	return makeColor(cpBaseByte[0],cpBaseByte[1],cpBaseByte[2]);
}


/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::setPixel(int x,int y,colort color)
{
	ASSERT_PIXEL(x,y);

	byte* pBaseByte = getPixelBuffer(x,y);

	pBaseByte[0] = getBValue(color);
	pBaseByte[1] = getGValue(color);
	pBaseByte[2] = getRValue(color);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::fill(colort color)
{
	byte* p = getPixelBuffer(-1,0);
//dword]ł͍Ō̈̓obt@̊OɏoĂ܂̂ŁB
	for (int i=0;i<(m_iWidth*m_iHeight)-1;i++)
	{
		*(dword*)p = color;
		p+=3;
	}

	setPixel(m_iWidth-1,m_iHeight-1,color);
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Bitmap::read(cpchar1 cszPath)
{
	File file;
	if (! file.open(cszPath))		return false;

//BMPt@Cwb_̓ǂݍ
	int iRead=0;
	BitmapFileHeader bitmapFileHeader;
	BitmapInfoHeader bitmapInfoHeader;

	byte abyBuffer[100];
	iRead+=file.read(abyBuffer,iRead,14);
	bitmapFileHeader.set(abyBuffer);

	iRead+=file.read(abyBuffer,iRead,40);
	bitmapInfoHeader.set(abyBuffer);

//_ł24rbgȊO͑ΉĂȂB
	if (bitmapInfoHeader.m_wBitFormat != 24)		return false;
	ASSERT(m_iWidth>0 && m_iHeight>0);


//BݒB
	m_strPath = cszPath;
	byte* pBuffer = getCanvas(bitmapInfoHeader.m_iWidth,bitmapInfoHeader.m_iHeight);

	file.read(pBuffer,bitmapFileHeader.m_dwOffsetToData,m_bufferData.getSize());

	return true;
}

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::write(cpchar1 cszPath) const
{
	ASSERT(m_iBitCount==8 || m_iBitCount==24);

const int iBMP_HEADER_SIZE = 0x36;

//54oCg
	byte abyHeader[] = {
0x42,0x4D,				//00:t@C̎ID
0x36,0x10,0x0E,0x00,	//02:TCYBB640*480*24 = E10000BɃwb_[ 
0x00,0x00,				//06:ŒB0
0x00,0x00,				//08:ŒB0
0x36,0x00,0x00,0x00,	//0A:摜f[^{̂ւ̃ItZbg

0x28,0x00,0x00,0x00,	//0E:ŒBwb_[TCY
0x80,0x02,0x00,0x00,	//12:m_nWidth.			
0xE0,0x01,0x00,0x00,	//16:biHeight.			
0x01,0x00,				//1A:biPlanes.			ŒBJ[v[
0x18,0x00,				//1C:m_wBitFormat.		J[rbg
0x00,0x00,0x00,0x00,	//1E:biCompression.		ŒBkXL[(0=Ȃj
0x00,0x10,0x0E,0x00,	//22:biSizeImage.		摜̃TCYik̂݁j
0x13,0x0B,0x00,0x00,	//26:biXPelsPerMeter.	ŒB𑜓x
0x13,0x0B,0x00,0x00,	//2A:biYPelsPerMeter.	ŒB𑜓x
0x00,0x00,0x00,0x00,	//2E:biClrUsed.			ŒBF
0x00,0x00,0x00,0x00};	//32:biClrImportant.	ŒBKvȐFi݂͎gpĂȂ)


	int* piSize		= (int*) (abyHeader + 2);
	int* piMainDataOffset = (int*) (abyHeader + 10);
	int* piWidth	= (int*) (abyHeader + 18);
	int* piHeight	= (int*) (abyHeader + 22);
	int* piBitCount	= (int*) (abyHeader + 28);

	int iSize=0;
	int iMainDataOffset=0;

	iSize = m_iLineSize * m_iHeight + iBMP_HEADER_SIZE;
	iMainDataOffset = iBMP_HEADER_SIZE;

	*piSize = iSize;
	*piMainDataOffset = iMainDataOffset;
	*piWidth			= m_iWidth;
	*piHeight			= m_iHeight;
	*piBitCount			= 24;

	File file(cszPath,true);
	int iWrite=0;
	iWrite += file.write(abyHeader,iWrite,sizeof(abyHeader));
	iWrite += file.write(m_bufferData.getData(),iWrite,m_bufferData.getSize());
}


//̑֐////////////////
/**
	@date	2005/08/20	junjunn 쐬
*/
int	getBMPLineSize(int iWidth)
{
	int iLineBits = 3 * iWidth;

	int iExcess = iLineBits % 4;
	if (iExcess != 0)
	{
		iLineBits += (4-iExcess);
	}

	return iLineBits;
}


}	// namespace monapi2
