/**
	@file	Rect.cpp
	@brief	񎟏ł̎lp`

	񎟏ł̎lp`

	License=Mona License
	@version $Revision: 1.1 $
	@date	$Date: 2005/09/05 14:58:05 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "../Basic/Math.h"
#include "Rect.h"
#include "Size.h"
#include "Point.h"

namespace monapi2	{

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Size Rect::getSize() const
{
	Size size(getWidth(),getHeight());
	return size;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Rect::getLeftTopPoint() const
{
	Point point(getLeft(),getTop());
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Rect::getRightBottomPoint() const
{
	Point point(getRight(),getBottom());
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Rect::getCenterPoint() const
{
	Point point((getLeft()+getRight())/2,(getTop()+getBottom())/2);
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Rect::isEqual(const class Point* cpPointLeftTop,const class Size* cpSize) const
{
	return isEqual(cpPointLeftTop->getX(),cpPointLeftTop->getY(),cpPointLeftTop->getX()+cpSize->getWidth(),cpPointLeftTop->getY()+cpSize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Rect::isEqual(const Point* cpPointLeftTop,const Point* cpPointRightBottom) const
{
	return isEqual(cpPointLeftTop->getX(),cpPointLeftTop->getY(),cpPointRightBottom->getX(),cpPointRightBottom->getY());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Rect::isPointInside(int x,int y) const
{
	return (getLeft()<=x && x<getRight() && getTop()<=y && y<getBottom());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Rect::isPointInside(const Point* cppoint) const
{
	return isPointInside(cppoint->getX(),cppoint->getY());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Rect::move(const Size* cpSize)
{
	move(cpSize->getWidth(),cpSize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Rect::normalize()
{
	if (m_iLeft>m_iRight) swap(&m_iLeft,&m_iRight);
	if (m_iTop>m_iBottom) swap(&m_iTop,&m_iBottom);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Rect::set(const Point* cpPointLeftTop,const Size* cpSize)
{
	set(cpPointLeftTop->getX(),cpPointLeftTop->getY(),cpPointLeftTop->getX()+cpSize->getWidth(),cpPointLeftTop->getY()+cpSize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Rect::set(const Point* cpPointLeftTop,const Point* cpPointRightBottom)
{
	set(cpPointLeftTop->getX(),cpPointLeftTop->getY(),cpPointRightBottom->getX(),cpPointRightBottom->getY());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Rect::inflate(const Size* cpsize)
{
	inflate(cpsize->getWidth(),cpsize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Rect Rect::getIntersect(const Rect* cprect1,const Rect* cprect2)
{
	Rect rectReturn;
	const Rect* cprectS,*cprectL;	//smalllarge

//X
	if (cprect1->getLeft() <= cprect2->getLeft())
	{
		cprectS	= cprect1;
		cprectL	= cprect2;
	}
	else
	{
		cprectS	= cprect2;
		cprectL	= cprect1;
	}

//Ȃ̂0ԂB
	if (cprectL->getLeft() >= cprectS->getRight())	return Rect(0,0,0,0);

	rectReturn.m_iLeft = cprectL->getLeft();
	rectReturn.m_iRight = getMin(cprectS->getRight(),cprectL->getRight());

//Y
	if (cprect1->getTop() <= cprect2->getTop())
	{
		cprectS	= cprect1;
		cprectL	= cprect2;
	}
	else
	{
		cprectS	= cprect2;
		cprectL	= cprect1;
	}

//Ȃ̂0ԂB
	if (cprectL->getTop() >= cprectS->getBottom())	return Rect(0,0,0,0);

	rectReturn.m_iTop = cprectL->getTop();
	rectReturn.m_iBottom = getMin(cprectS->getBottom(),cprectL->getBottom());

	return rectReturn;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Rect Rect::getMinimumInclude(const Rect* cprect1,const Rect* cprect2)
{
	Rect rectReturn;

	rectReturn.m_iLeft	= getMin(cprect1->getLeft(),cprect2->getLeft());
	rectReturn.m_iRight = getMax(cprect1->getRight(),cprect2->getRight());
	rectReturn.m_iTop	= getMin(cprect1->getTop(),cprect2->getTop());
	rectReturn.m_iBottom= getMax(cprect1->getBottom(),cprect2->getBottom());

	return rectReturn;
}


}		//namespace monapi2
