/**
	@file	Size.h
	@brief	ƍ̓񎟌TCY

	ƍ̓񎟌TCY

	License=Mona License
	@version $Revision: 1.1 $
	@date	$Date: 2005/09/05 14:58:05 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_MULTIMEDIA_SIZE_H
#define _MONAPI2_MULTIMEDIA_SIZE_H

#include "../Basic/Switch.h"
#include "../Basic/Type.h"

namespace monapi2	{

/**
	@brief	ƍ̓񎟌TCYBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
class Size
{
public:
	Size()											{set(0,0);}
	Size(int iWidth,int iHeight)					{set(iWidth,iHeight);}
	Size(const Size* cpSize)						{set(cpSize);}

//擾
	int getWidth() const							{return m_iWidth;}
	int getHeight() const							{return m_iHeight;}
	bool isEqual(int iWidth,int iHeight) const		{return (m_iWidth==iWidth && m_iHeight==iHeight);}
	bool isEqual(const Size* cpSize) const			{return isEqual(cpSize->m_iWidth,cpSize->m_iHeight);}
	bool operator ==(const Size& crefSize) const	{return isEqual(crefSize.m_iWidth,crefSize.m_iHeight);}
	bool operator !=(const Size& crefSize) const 	{return ! isEqual(&crefSize);}
	Size add(int iWidth,int iHeight) const			{Size Size(m_iWidth+iWidth,m_iHeight+iHeight);return Size;}
	Size add(const class Size* cpSize) const		{Size Size(m_iWidth+cpSize->m_iWidth,m_iHeight+cpSize->m_iHeight);return Size;}
	Size operator +(const Size& crefSize) const		{Size Size(m_iWidth+crefSize.m_iWidth,m_iHeight+crefSize.m_iHeight);return Size;}
	Size subtract(int iWidth,int iHeight) const		{Size Size(m_iWidth-iWidth,m_iHeight-iHeight);return Size;}
	Size subtract(const class Size* cpSize) const	{Size Size(m_iWidth-cpSize->m_iWidth,m_iHeight-cpSize->m_iHeight);return Size;}
	Size operator -(const Size& crefSize) const		{Size Size(m_iWidth-crefSize.m_iWidth,m_iHeight-crefSize.m_iHeight);return Size;}

// 
	void set(int iWidth,int iHeight)				{m_iWidth=iWidth;m_iHeight=iHeight;}
	void set(const Size* cpSize)					{set(cpSize->m_iWidth,cpSize->m_iHeight);}
	void operator =(const Size& crefSize)			{set(crefSize.m_iWidth,crefSize.m_iHeight);}
	void addSelf(int iWidth,int iHeight)			{m_iWidth+=iWidth;m_iHeight+=iHeight;}
	void addSelf(const class Size* cpSize)			{addSelf(cpSize->getWidth(),cpSize->getHeight());}
	void operator +=(const Size& crefSize)			{addSelf(&crefSize);}
	void subtractSelf(int iWidth,int iHeight)		{addSelf(-iWidth,-iHeight);}
	void subtractSelf(const class Size* cpSize)		{addSelf(-cpSize->getWidth(),-cpSize->getHeight());}
	void operator -=(const class Size& crefSize)	{subtractSelf(&crefSize);}

public:
	int m_iWidth;
	int m_iHeight;
};

	
}	//namespace monapi2

#endif
