/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __FONTMETRICS_H__
#define __FONTMETRICS_H__

#define inGetUInt16(b) (unsigned short)( (unsigned short)((b)[1])<<8 | (unsigned short)((b)[0]) )
#define inGetUInt32(b) (dword)( (dword)((b)[3])<<24 | (dword)((b)[2])<<16 | (dword)((b)[1])<<8 | (dword)((b)[0]) )

namespace baygui {
	/**
	 tHgNX
	 */
	class FontMetrics : public Object
	{
	private:
		/** tHgItZbgXg */
		static int offsetListLength;
		/** tHgItZbgXg */
		static int* offsetList;
		/** tHgf[^ */
		static unsigned char* defaultFontData;
		/** tHgX^C */
		int fontStyle;
		/** GUIT[o[ID */
		dword guisvrID;

	public:
		/** RXgN^ */
		FontMetrics();
		
		/** fXgN^ */
		virtual ~FontMetrics();
		
		/**
		 UCS-4R[h󂯎ēWJςݕf[^Ԃ
		 @param ucs4 UCS-4R[hi4oCgj
		 @param offset [out] σtHgł offset = widthAŒtHgł offset > width
		 @param width [out] ̕
		 @param height [out] ̍
		 @param data [out] WJςݕf[^
		*/
		bool decodeCharacter(wchar ucs4, int* offset, int* width, int* height, char* data);
		
		/**
		 ̕𓾂
		 @param str isΉj
		 */
		int getWidth(const String& str);
		
		/**
		 ̍𓾂
		 @param str isΉj
		 */
		int getHeight(const String& str);
		
		/** tHgX^C𓾂 */
		inline int getFontStyle() { return this->fontStyle; }
		
		/** tHgX^Cݒ肷 */
		inline void setFontStyle(int style) { this->fontStyle = style; }
	};
}

#endif // __FONTMETRICS_H__
