/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#if !defined(_WINDOW_H_INCLUDED_)
#define _WINDOW_H_INCLUDED_

namespace baygui {
	/**
	 EBhENX
	*/
	class Window : public Container {
	public:
		//
		// EBhȄ
		//
		/** ʏ펞 */
		static const int STATE_NORMAL = 0;
		/** EBhEړ */
		static const int STATE_MOVING = 1;
		
	private:
		/** CL[ */
		int modifiers;
		/** EBhȄ */
		int state;
		/** ȑÕ}EXXW */
		int preX;
		/** ȑÕ}EXYW */
		int preY;
		/** ItZbgX */
		int offsetX;
		/** ItZbgY */
		int offsetY;
		/** I[o[bvEBhȄ */
		dword overlap;
		/** stO */
		bool isRunning;
		/** ^C}[ID */
		dword timerID;
		/** L[Cxg */
		KeyEvent keyEvent;
		/** }EXCxg */
		MouseEvent mouseEvent;
		/** ^C}[Cxg */
		Event timerEvent;
		/** JX^Cxg */
		Event customEvent;

	protected:
		/** t`̏ */
		int border;
		/** zuʒu */
		Insets insets;
		/** `̈ */
		Graphics* _g;
		/** `obt@[ */
		Image* _buffer;
		/** `̈ */
		Graphics* __g;
		/** `obt@[ */
		Image* __buffer;
		/** GUIT[o[ID */
		dword guisvrID;
		/** GUIT[o[̃EBhEIuWFNg */
		guiserver_window* _window;
		/** WindowListenerꗗ */
		Vector windowListenerList;
		/** TimerListenerꗗ */
		Vector timerListenerList;
	
	protected:
		/** {^NbNꂽǂ */
		virtual bool getCloseButtonClicked(int px, int py)
		{
			return false;
		}
		
		/** ^Cgo[NbNꂽǂ */
		virtual bool getTitlebarClicked(int px, int py)
		{
			return (0 <= px && px < getWidth() && 0 <= py && py < getHeight()) ? true : false;
		}

	public:
		/** RXgN^ */
		Window();
		
		/** fXgN^ */
		virtual ~Window();

		/**
		 inh.
		 Window::run()ŌĂ΂B
		 Ǝ̏t^ƂWindow::addNotify()ɌĂԂƁB
		*/
		virtual void addNotify();
		
		/**
		 ijnh.
		 fXgN^ŌĂ΂B
		 Ǝ̏t^ƂWindow::removeNotify()ŌĂԂƁB
		 */
		virtual void removeNotify();

		/** nh𓾂 */
		inline dword getHandle() { return (this->_window != NULL) ? this->_window->Handle : 0; }
		
		/** zuʒu𓾂 */
		virtual Insets* getInsets();
		
		/** `IuWFNg𓾂 */
		virtual Graphics* getGraphics();
		
		/** obt@[𓾂 */
		virtual Image* getBuffer();
		
		/**
		 \Ԃݒ肷
		 @param visible \ (true / false)
		 */
		virtual void setVisible(bool visible);
		
		/**
		 ʒuύX
		 @param x XW
		 @param y YW
		*/
		virtual void setLocation(int x, int y);
		
		/**
		 ^C}[Zbg
		 @param duration ^C}[Cxg܂ł̎[ms]
		 */
		virtual void setTimer(int duration);
		
		/** ĕ` */
		virtual void repaint();
		
		/** iXV */
		virtual void update();
		
		/** iXV */
		virtual void update(int x, int y, int w, int h);
		
		/** Cxg */
		virtual void dispatchEvent(Event* event);
		
		/** WindowListenerǉ */
		virtual void addWindowListener(WindowListener* l);
		
		/** WindowListenerǉ */
		virtual void removeWindowListener(WindowListener* l);
		
		/** WindowListenerǉ */
		virtual void processWindowEvent(WindowEvent* e);
		
		/** TimerListenerǉ */
		virtual void addTimerListener(TimerListener* l);
		
		/** TimerListenerǉ */
		virtual void removeTimerListener(TimerListener* l);
		
		/** TimerListenerǉ */
		virtual void processTimerEvent(TimerEvent* e);
		
		/** AvP[V[v𔲂 */
		virtual void stop();
		
		/** AvP[V[v */
		virtual void run();
	};
}

#endif // _WINDOW_H_INCLUDED_
