/*
 * AbstractJsonRPCClient.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.jsonrpc;

import java.util.Map;

import org.monache.lib.json.JsonObject;

import net.arnx.jsonic.JSON;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public abstract class AbstractJsonRPCClient implements JsonRPCClient {

	protected abstract String request(String jsonRequestString) throws JsonRPCException;

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.jsonrpc.JsonRPCClient#call(java.lang.Object, java.lang.Class)
	 * @since 1.0
	 */
	public <T1, T2> T2 call(T1 requestObject, Class<? extends T2> responseObjectClass) throws JsonRPCException {
		// Bean -> JSON
		String req = JSON.encode(requestObject);
		// execute JSON-RPC
		String res = request(req);
		// JSON -> Bean
		T2 responseObject = JSON.decode(res, responseObjectClass);
		if (responseObject instanceof JsonRPCResponseObject) {
			((JsonRPCResponseObject) responseObject).setJsonString(res);
		}
		return responseObject;
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.jsonrpc.JsonRPCClient#call(java.lang.Object)
	 * @since 1.0
	 */
	public <T1> JsonObject call(T1 requestObject) throws JsonRPCException {
		// Bean -> JSON
		String req = JSON.encode(requestObject);
		// execute JSON-RPC
		String res = request(req);
		// JSON -> Bean
		JSON json = new JSON();
		JsonObject jsonObj = new JsonObject();
		jsonObj.setJsonMap((Map<?,?>)json.parse(res));
		jsonObj.setJsonString(res);

		return jsonObj;
	}
	
	
}
