/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * <P>
 * ϥȥ꡼˵ǽäϤХåե˳Ǽ뵡ǽ mark ᥽åɤ reset ᥽åɤ򥵥ݡȤ뵡ǽɲäޤ
 * ExpandedInputStream ȡХåե󤬺ޤ
 * ȥ꡼ΥХȤɤ߹ޤ뤫åפȡǼƤϥȥ꡼फɬפ˱ư٤¿ΥХȤХåե佼ޤ
 * mark ڥ졼ϥȥ꡼֤򵭲ޤ
 * reset ڥ졼ϡǼƤϥȥ꡼फ鿷ХȤˡǸ˼¹Ԥ줿 mark ڥ졼ʹߤɤ߹ޤ줿٤ƤΥХȤɤ߹ߤޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class ExpandedInputStream
	extends BufferedInputStream
{

	/**
	 * <P>
	 * ExpandedInputStream ΰǤϥȥ꡼ in 򤢤ȤǻѤǤ褦¸ޤ
	 * Хåե󤬺졢buf ˳Ǽޤ
	 * </P>
	 * @param in ܤȤʤϥȥ꡼
	 */
	public ExpandedInputStream(InputStream in)
	{
		super(in);
	}

	/**
	 * <P>
	 * ꤵ줿Хåե ExpandedInputStream ΰǤϥȥ꡼ in 򤢤ȤǻѤǤ褦¸ޤ
	 * Ĺ size Хåե󤬺졢buf ˳Ǽޤ
	 * </P>
	 * @param in ܤȤʤϥȥ꡼
	 * @param size Хåե
	 * @exception IllegalArgumentException size  0 ʲξ
	 */
	public ExpandedInputStream(InputStream in, int size)
	{
		super(in, size);
	}

	/**
	 * <P>
	 * ϥȥ꡼फ餹٤ƤƤɤ߹ߤޤ
	 * </P>
	 * @exception IOException ϥ顼ȯ
	 */
	public synchronized byte[] readAll()
		throws IOException
	{
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		writeTo(out);

		return out.toByteArray();
	}

	/**
	 * <P>
	 * ϥȥ꡼Τ٤ƤƤ򡢻ꤵ줿ϥȥ꡼˽񤭹ߤޤ
	 *  out.write(byte[], int, int) Ȥäƽϥȥ꡼ write ᥽åɤƤӽФΤƱǤ
	 * </P>
	 * @param out ǡ񤭹ϥȥ꡼
	 * @exception IOException ϥ顼ȯ
	 */
	public synchronized void writeTo(OutputStream out)
		throws IOException
	{
		byte[] b = new byte[buf.length];
		int len = 0;
		while ((len = read(b, 0, b.length)) != -1)
		{
			out.write(b, 0, len);
		}
	}

	/**
	 * <P>
	 * ExpandedInputStream ΰǤϥȥ꡼ in 򤢤ȤǻѤǤ褦¸ޤ
	 * in  ExpandedInputStream ξϡ֤ޤ
	 * </P>
	 * @param in ܤȤʤϥȥ꡼
	 */
	public synchronized static ExpandedInputStream valueOf(InputStream in)
	{
		if (in instanceof ExpandedInputStream)
		{
			return (ExpandedInputStream)in;
		}
		else
		{
			return new ExpandedInputStream(in);
		}
	}
}
