/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * <P>
 * ϥȥ꡼եȥεǽޤ
 * ϥȥ꡼եȥϡϥȥ꡼ե롢ѥʸ󡢥ХURL ʤɤΥ֥Ȥ뤿˻Ѥޤ
 * </P>
 * <P>
 * μ getInputStream ᥽åɤϡExpandedInputStream ֤ޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class InputStreamFactory
{

	/**
	 * <P>
	 * InputStreamFactory ֥Ȥޤ
	 * </P>
	 */
	public InputStreamFactory()
	{
		super();
	}

	/**
	 * <P>
	 * ե륷ƥμºݤΥե (File ֥ file ˤ) ³뤳ȤˤꡢFileInputStream ޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkRead ᥽åɤfile ˤäɽѥȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ꤵ줿ե뤬¸ߤʤ̤ΥեǤϤʤǥ쥯ȥǤ뤫ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param file ɤ߹ߤΤ˳ե
	 * @return եɤ߹िϥȥ꡼ (ExpandedInputStream)
	 * @exception FileNotFoundException ե뤬¸ߤʤ̤ΥեǤϤʤǥ쥯ȥǤ뤫ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckRead ᥽åɤեؤɤ߹ߥݤ
	 */
	public synchronized InputStream getInputStream(File file) throws FileNotFoundException
	{
		return new ExpandedInputStream(new FileInputStream(file));
	}

	/**
	 * <P>
	 * ե륷ƥμºݤΥե (ѥ̾ path ˤ) ³뤳ȤˤꡢFileInputStream ޤ
	 * Υե³ɽˡ FileDescriptor ֥Ȥޤ
	 * </P>
	 * <P>
	 * ޤƥޥ͡㤬¸ߤ硢checkRead ᥽åɤ name ȤƸƤӽФޤ
	 * </P>
	 * <P>
	 * ꤵ줿ե뤬¸ߤʤ̤ΥեǤϤʤǥ쥯ȥǤ뤫ޤϤʤ餫ͳǳȤǤʤϡFileNotFoundException ޤ
	 * </P>
	 * @param name ƥ¸Υե̾
	 * @return եɤ߹िϥȥ꡼ (ExpandedInputStream)
	 * @exception FileNotFoundException ե뤬¸ߤʤ̤ΥեǤϤʤǥ쥯ȥǤ뤫ޤϤʤ餫ͳǳȤǤʤ
	 * @exception SecurityException ƥޥ͡㤬¸ߤcheckRead ᥽åɤեؤɤ߹ߥݤ
	 */
	public synchronized InputStream getInputStream(String path) throws FileNotFoundException
	{
		return getInputStream(new File(path));
	}

	/**
	 * <P>
	 * bytes ХåեȤƻȤ褦ˡByteArrayInputStream ޤ
	 * Хåեϥԡޤ
	 * pos νͤ 0 ǡcount νͤ bytes ĹǤ
	 * </P>
	 * @param bytes ϥХåե
	 * @return Хɤ߹िϥȥ꡼ (ExpandedInputStream)
	 */
	public synchronized InputStream getInputStream(byte[] bytes)
	{
		return new ExpandedInputStream(new ByteArrayInputStream(bytes));
	}

	/**
	 * <P>
	 * bytes ХåեȤƻȤ褦ˡByteArrayInputStream ޤ
	 * pos νͤ offset ǡcount νͤ offset + len Ǥ
	 * Хåեϥԡޤ
	 * ХåեΥޡϻꤷեåȤꤵޤ
	 * </P>
	 * @param bytes ϥХåե
	 * @param offset ХåեΥХɤ߹߳ϥեå
	 * @param length Хåեɤ߹Хȿ
	 * @return Хɤ߹िϥȥ꡼ (ExpandedInputStream)
	 */
	public synchronized InputStream getInputStream(byte[] bytes, int offset, int length)
	{
		return new ExpandedInputStream(new ByteArrayInputStream(bytes, offset, length));
	}

	/**
	 * <P>
	 * url ؤ³Ω³ɤ߹ߤԤ InputStream ޤ
	 * </P>
	 * @param url URL
	 * @return URL ³Ϥɤ߹िϥȥ꡼ (ExpandedInputStream)
	 * @exception IOException 㳰ȯ
	 */
	public synchronized InputStream getInputStream(URL url) throws IOException
	{
		return new ExpandedInputStream(url.openStream());
	}
}
