/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

/**
 * <P>
 * ץߥƥַͤޥåԥ󥰤륪֥ȤǤ
 *  java.util.Map ֥ȤΤ褦 Map ˡץߥƥַͤޥåԥ󥰤뤳Ȥǽˤޤ
 * boolean byte char double float int long short ¾Υץߥƥַͤϡ֥Ȥ˥åפ Map ֥Ȥ˥ޥåԥ󥰤ޤ
 * </P>
 * @author Kenichi Fukuda
 */
public interface PrimitiveHolderMap
	extends java.util.Map
{

	/**
	 * <P>
	 * ޥåפΥޥåפͤϥȥ꡼ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.io.InputStream getInputStream(Object key);

	/**
	 * <P>
	 * ϥȥ꡼ޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setInputStream(Object key, java.io.InputStream value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.math.BigDecimal ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.math.BigDecimal getBigDecimal(Object key);

	/**
	 * <P>
	 *  java.math.BigDecimal ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setBigDecimal(Object key, java.math.BigDecimal value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.math.BigInteger ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.math.BigInteger getBigInteger(Object key);

	/**
	 * <P>
	 *  java.math.BigInteger ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setBigInteger(Object key, java.math.BigInteger value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 boolean ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public boolean getBoolean(Object key);

	/**
	 * <P>
	 *  boolean ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setBoolean(Object key, boolean value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 byte ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public byte getByte(Object key);

	/**
	 * <P>
	 *  byte ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setByte(Object key, byte value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 byte ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public byte[] getBytes(Object key);

	/**
	 * <P>
	 *  byte ޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setBytes(Object key, byte[] value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 char ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public char getChar(Object key);

	/**
	 * <P>
	 *  char ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setChar(Object key, char value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.io.Reader ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.io.Reader getReader(Object key);

	/**
	 * <P>
	 *  java.io.Reader ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setReader(Object key, java.io.Reader value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.util.Date ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.util.Date getDate(Object key);

	/**
	 * <P>
	 * ޥåפΥޥåפͤʸɽ pattern ǻꤷաѥǲϤơjava.util.Date ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @param pattern աѥ
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public java.util.Date parseDate(Object key, String pattern);

	/**
	 * <P>
	 *  java.util.Date ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setDate(Object key, java.util.Date value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 double ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public double getDouble(Object key);

	/**
	 * <P>
	 *  double ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setDouble(Object key, double value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 float ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public float getFloat(Object key);

	/**
	 * <P>
	 *  float ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setFloat(Object key, float value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 int ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public int getInt(Object key);

	/**
	 * <P>
	 *  int ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setInt(Object key, int value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 long ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public long getLong(Object key);

	/**
	 * <P>
	 *  long ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setLong(Object key, long value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 Object ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public Object getObject(Object key);

	/**
	 * <P>
	 *  Object ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setObject(Object key, Object value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 short ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public short getShort(Object key);

	/**
	 * <P>
	 *  short ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setShort(Object key, short value);

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 String ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 */
	public String getString(Object key);

	/**
	 * <P>
	 *  String ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 */
	public void setString(Object key, String value);

}
