/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext;

import java.util.HashMap;
import java.util.Map;

import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoderImpl;

/**
 * <P>
 * Υ饹ϡTagTemplate ֥ȤݻJavaServer Pages ˤƥॿ¹Ԥ줿ݤˡΥ°󶡤ޤ
 * </P>
 * @author user
 */
public class TagManager
	implements Plugin
{

	/** ׵륵֥åȤΥѥΥޥå */
	private Map tagTemplateMap = new HashMap();

	/** HTMLΤΥ󥳡ǥ󥰥֥ */
	private HtmlEncoder htmlEncoder = null;

	/** null Υ̾ */
	private static final String NULL_NAME = "";

	/** null Υ */
	private static final String NULL_TAGTYPE = "";

	/**
	 * <P>
	 * TagManager ۤޤ
	 * </P>
	 */
	public TagManager()
	{
		super();
		this.setHtmlEncoder(new HtmlEncoderImpl());
	}

	/**
	 * <P>
	 * TagTemplate ֥Ȥޥåץ֥Ȥ˴Ϣդ뤿Υޤ
	 * </P>
	 * <P>
	 * ϼΤ褦ʥޤ
	 * <CODE>
	 * TagTemplate[tagType=<I>Υ</I>,name=<I>̾</I>]
	 * </CODE>
	 * </P>
	 * @param tagType Υ
	 * @param name ̾
	 * @return TagTemplate ֥ȤΥ
	 */
	public synchronized String generateTagTemplateKey(String tagType, String name)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("TagTemplate[");
		buf.append("tagType=").append((tagType != null) ? tagType : NULL_TAGTYPE);
		buf.append(",");
		buf.append("name=").append((name != null) ? name : NULL_NAME);
		buf.append("]");

		return buf.toString();
	}

	/**
	 * <P>
	 * ΥƥȤ TagTemplate ɲäޤ
	 * </P>
	 * @param fe ƥȤɲä TagTemplate
	 * @exception IllegalArgumentException ƱפƱ̾ TagTemplate ä
	 */
	public synchronized void addTagTemplate(TagTemplate fe)
	{
		String key = generateTagTemplateKey(fe.getTagType(), fe.getName());
		if (tagTemplateMap.containsKey(key))
		{
			throw new IllegalArgumentException("TagTemplate already exists: " + key);
		}
		tagTemplateMap.put(key, fe);
	}

	/**
	 * <P>
	 * ΥƥȤꤵ줿̾ TagTemplate ֤ޤ
	 * ƥȤ̾ TagTemplate ݻƤʤ null ֤ޤ
	 * </P>
	 * @param tagType TagTemplate Υ
	 * @param name TagTemplate ̾
	 * @return ꤵ줿̾ TagTemplate ̾Ф TagTemplate ƥȤˤʤ null
	 */
	public synchronized TagTemplate getTagTemplate(String tagType, String name)
	{
		String key = generateTagTemplateKey(tagType, name);
		return (TagTemplate)tagTemplateMap.get(key);
	}

	/**
	 * <P>
	 * TagManager ץ饰̤뤿Υ֤ޤ
	 * </P>
	 * @return TagManager ץ饰̤뤿Υ
	 * @see jp.morpho.webapp.Plugin#getPluginKey()
	 */
	public final String getPluginKey()
	{
		return PluginKeys.fieldContext;
	}

	/**
	 * <P>
	 * ץ饰󥳥ƥȤꤷޤ
	 * ե졼Ǥϡץ饰󥤥󥹥󥹤ɲä줿ˤΥ᥽åɤƤӽФޤ
	 * </P>
	 * @param fc Υ󥹥󥹤ɲä FrameworkContext ֥
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void setPluginContext(PluginContext fc)
		throws PluginException
	{
	}

	/**
	 * <P>
	 * pluginActivate ᥽åɤϡ󥹥󥹤֤ˤʤȤ˸ƤӽФޤ
	 * 󥹥󥹤ޤ
	 * </P>
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void pluginActivate()
		throws PluginException
	{
	}

	/**
	 * <P>
	 * ե졼Ǥϡץ饰󥪥֥Ȥ֤ͭ򽪤餻ˤΥ᥽åɤƤӽФޤ
	 * ٤ƤΥ꥽ޤ
	 * </P>
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void pluginRemove()
		throws PluginException
	{
	}

	/**
	 * Returns the htmlEncoder.
	 * @return HtmlEncoder
	 */
	public HtmlEncoder getHtmlEncoder()
	{
		return htmlEncoder;
	}

	/**
	 * Sets the htmlEncoder.
	 * @param htmlEncoder The htmlEncoder to set
	 */
	public void setHtmlEncoder(HtmlEncoder htmlEncoder)
	{
		this.htmlEncoder = htmlEncoder;
	}

}
