/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

/**
 * <P>
 * Generic Attributes  coreattrs ɽޤ
 * </P>
 * <P>
 * coreattrs  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ENTITY % coreattrs
 *  "id          ID             #IMPLIED  -- document-wide unique id --
 *   class       CDATA          #IMPLIED  -- space-separated list of classes --
 *   style       %StyleSheet;   #IMPLIED  -- associated style info --
 *   title       %Text;         #IMPLIED  -- advisory title --"
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public interface CoreAttrs
{
	/**
	 * Returns the cls.
	 * @return String
	 */
	public String getStyleClass();

	/**
	 * Returns the id.
	 * @return String
	 */
	public String getStyleId();

	/**
	 * Returns the style.
	 * @return String
	 */
	public String getStyle();

	/**
	 * Returns the title.
	 * @return String
	 */
	public String getTitle();

	/**
	 * Sets the cls.
	 * @param cls The cls to set
	 */
	public void setStyleClass(String cls);

	/**
	 * Sets the id.
	 * @param id The id to set
	 */
	public void setStyleId(String id);

	/**
	 * Sets the style.
	 * @param style The style to set
	 */
	public void setStyle(String style);

	/**
	 * Sets the title.
	 * @param title The title to set
	 */
	public void setTitle(String title);

}
