/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.jsp.tagext.TagManager;
import jp.morpho.webapp.servlet.jsp.tagext.TagTemplate;

/**
 * <P>
 * HTML  INPUT ǤϥɥǤ
 * ƥϡåܥå饸ܥʤɤΥȥŬϥɥ뤿ˡ֥饹Ȥ abstract 饹󶡤ޤ
 * </P>
 * <P>
 * INPUT  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ENTITY % InputType
 *   "(TEXT | PASSWORD | CHECKBOX |
 *     RADIO | SUBMIT | RESET |
 *     FILE | HIDDEN | IMAGE | BUTTON)"
 *    &gt;
 * 
 * &lt;!-- attribute name required for all but submit and reset --&gt;
 * &lt;!ELEMENT INPUT - O EMPTY              -- form control --&gt;
 * &lt;!ATTLIST INPUT
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   type        %InputType;    TEXT      -- what kind of widget is needed --
 *   name        CDATA          #IMPLIED  -- submit as part of form --
 *   value       CDATA          #IMPLIED  -- Specify for radio buttons and checkboxes --
 *   checked     (checked)      #IMPLIED  -- for radio buttons and check boxes --
 *   disabled    (disabled)     #IMPLIED  -- unavailable in this context --
 *   readonly    (readonly)     #IMPLIED  -- for text and passwd --
 *   size        CDATA          #IMPLIED  -- specific to each type of field --
 *   maxlength   NUMBER         #IMPLIED  -- max chars for text fields --
 *   src         %URI;          #IMPLIED  -- for fields with images --
 *   alt         CDATA          #IMPLIED  -- short description --
 *   usemap      %URI;          #IMPLIED  -- use client-side image map --
 *   ismap       (ismap)        #IMPLIED  -- use server-side image map --
 *   tabindex    NUMBER         #IMPLIED  -- position in tabbing order --
 *   accesskey   %Character;    #IMPLIED  -- accessibility key character --
 *   onfocus     %Script;       #IMPLIED  -- the element got the focus --
 *   onblur      %Script;       #IMPLIED  -- the element lost the focus --
 *   onselect    %Script;       #IMPLIED  -- some text was selected --
 *   onchange    %Script;       #IMPLIED  -- the element value was changed --
 *   accept      %ContentTypes; #IMPLIED  -- list of MIME types for file upload --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class InputTag
	extends ControlTagSupport
	implements TagTemplate
{

	/**
	 * <P>
	 * InputTag ޤ
	 * </P>
	 */
	public InputTag()
	{
		super();
	}

	/**
	 * <P>
	 * accept °֤ޤ
	 * </P>
	 * @return accept °
	 */
	public String getAccept()
	{
		return getAttributeMap().getString("accept");
	}

	/**
	 * <P>
	 * accesskey °֤ޤ
	 * </P>
	 * @return accesskey °
	 */
	public String getAccesskey()
	{
		return getAttributeMap().getString("accesskey");
	}

	/**
	 * <P>
	 * alt °֤ޤ
	 * </P>
	 * @return alt °
	 */
	public String getAlt()
	{
		return getAttributeMap().getString("alt");
	}

	/**
	 * <P>
	 * checked °֤ޤ
	 * </P>
	 * @return checked °
	 */
	public boolean getChecked()
	{
		return getAttributeMap().getBoolean("checked");
	}

	/**
	 * <P>
	 * disabled °֤ޤ
	 * </P>
	 * @return disabled °
	 */
	public boolean getDisabled()
	{
		return getAttributeMap().getBoolean("disabled");
	}

	/**
	 * <P>
	 * ismap °֤ޤ
	 * </P>
	 * @return ismap °
	 */
	public boolean getIsmap()
	{
		return getAttributeMap().getBoolean("ismap");
	}

	/**
	 * <P>
	 * maxlength °֤ޤ
	 * </P>
	 * @return maxlength °
	 */
	public String getMaxlength()
	{
		return getAttributeMap().getString("maxlength");
	}

	/**
	 * <P>
	 * name °֤ޤ
	 * </P>
	 * @return name °
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * onblur °֤ޤ
	 * </P>
	 * @return onblur °
	 */
	public String getOnblur()
	{
		return getAttributeMap().getString("onblur");
	}

	/**
	 * <P>
	 * onchange °֤ޤ
	 * </P>
	 * @return onchange °
	 */
	public String getOnchange()
	{
		return getAttributeMap().getString("onchange");
	}

	/**
	 * <P>
	 * onfocus °֤ޤ
	 * </P>
	 * @return onfocus °
	 */
	public String getOnfocus()
	{
		return getAttributeMap().getString("onfocus");
	}

	/**
	 * <P>
	 * onselect °֤ޤ
	 * </P>
	 * @return onselect °
	 */
	public String getOnselect()
	{
		return getAttributeMap().getString("onselect");
	}

	/**
	 * <P>
	 * readonly °֤ޤ
	 * </P>
	 * @return readonly °
	 */
	public boolean getReadonly()
	{
		return getAttributeMap().getBoolean("readonly");
	}

	/**
	 * <P>
	 * size °֤ޤ
	 * </P>
	 * @return size °
	 */
	public String getSize()
	{
		return getAttributeMap().getString("size");
	}

	/**
	 * <P>
	 * src °֤ޤ
	 * </P>
	 * @return src °
	 */
	public String getSrc()
	{
		return getAttributeMap().getString("src");
	}

	/**
	 * <P>
	 * tabindex °֤ޤ
	 * </P>
	 * @return tabindex °
	 */
	public String getTabindex()
	{
		return getAttributeMap().getString("tabindex");
	}

	/**
	 * <P>
	 * type °֤ޤ
	 * </P>
	 * @return type °
	 */
	public String getType()
	{
		return getAttributeMap().getString("type");
	}

	/**
	 * <P>
	 * usemap °֤ޤ
	 * </P>
	 * @return usemap °
	 */
	public String getUsemap()
	{
		return getAttributeMap().getString("usemap");
	}

	/**
	 * <P>
	 * value °֤ޤ
	 * </P>
	 * @return value °
	 */
	public String getValue()
	{
		return getAttributeMap().getString("value");
	}

	/**
	 * <P>
	 * template °֤ޤ
	 * </P>
	 * @return template °
	 */
	public String getTemplate()
	{
		return getAttributeMap().getString("template");
	}

	/**
	 * <P>
	 * accept °ꤷޤ
	 * </P>
	 * @param accept accept °
	 */
	public void setAccept(String accept)
	{
		getAttributeMap().setString("accept", accept);
	}

	/**
	 * <P>
	 * accesskey °ꤷޤ
	 * </P>
	 * @param accesskey accesskey °
	 */
	public void setAccesskey(String accesskey)
	{
		getAttributeMap().setString("accesskey", accesskey);
	}

	/**
	 * <P>
	 * alt °ꤷޤ
	 * </P>
	 * @param alt alt °
	 */
	public void setAlt(String alt)
	{
		getAttributeMap().setString("alt", alt);
	}

	/**
	 * <P>
	 * checked °ꤷޤ
	 * </P>
	 * @param checked checked °
	 */
	public void setChecked(boolean checked)
	{
		getAttributeMap().setBoolean("checked", checked);
	}

	/**
	 * <P>
	 * disabled °ꤷޤ
	 * </P>
	 * @param disabled disabled °
	 */
	public void setDisabled(boolean disabled)
	{
		getAttributeMap().setBoolean("disabled", disabled);
	}

	/**
	 * <P>
	 * ismap °ꤷޤ
	 * </P>
	 * @param ismap ismap °
	 */
	public void setIsmap(boolean ismap)
	{
		getAttributeMap().setBoolean("ismap", ismap);
	}

	/**
	 * <P>
	 * maxlength °ꤷޤ
	 * </P>
	 * @param maxlength maxlength °
	 */
	public void setMaxlength(String maxlength)
	{
		getAttributeMap().setString("maxlength", maxlength);
	}

	/**
	 * <P>
	 * name °ꤷޤ
	 * </P>
	 * @param name name °
	 */
	public void setName(String name)
	{
		getAttributeMap().setString("name", name);
	}

	/**
	 * <P>
	 * onblur °ꤷޤ
	 * </P>
	 * @param onblur onblur °
	 */
	public void setOnblur(String onblur)
	{
		getAttributeMap().setString("onblur", onblur);
	}

	/**
	 * <P>
	 * onchange °ꤷޤ
	 * </P>
	 * @param onchange onchange °
	 */
	public void setOnchange(String onchange)
	{
		getAttributeMap().setString("onchange", onchange);
	}

	/**
	 * <P>
	 * onfocus °ꤷޤ
	 * </P>
	 * @param onfocus onfocus °
	 */
	public void setOnfocus(String onfocus)
	{
		getAttributeMap().setString("onfocus", onfocus);
	}

	/**
	 * <P>
	 * onselect °ꤷޤ
	 * </P>
	 * @param onselect onselect °
	 */
	public void setOnselect(String onselect)
	{
		getAttributeMap().setString("onselect", onselect);
	}

	/**
	 * <P>
	 * readonly °ꤷޤ
	 * </P>
	 * @param readonly readonly °
	 */
	public void setReadonly(boolean readonly)
	{
		getAttributeMap().setBoolean("readonly", readonly);
	}

	/**
	 * <P>
	 * size °ꤷޤ
	 * </P>
	 * @param size size °
	 */
	public void setSize(String size)
	{
		getAttributeMap().setString("size", size);
	}

	/**
	 * <P>
	 * src °ꤷޤ
	 * </P>
	 * @param src src °
	 */
	public void setSrc(String src)
	{
		getAttributeMap().setString("src", src);
	}

	/**
	 * <P>
	 * tabindex °ꤷޤ
	 * </P>
	 * @param tabindex tabindex °
	 */
	public void setTabindex(String tabindex)
	{
		getAttributeMap().setString("tabindex", tabindex);
	}

	/**
	 * <P>
	 * type °ꤷޤ
	 * </P>
	 * @param type type °
	 */
	public void setType(String type)
	{
		getAttributeMap().setString("type", type);
	}

	/**
	 * <P>
	 * usemap °ꤷޤ
	 * </P>
	 * @param usemap usemap °
	 */
	public void setUsemap(String usemap)
	{
		getAttributeMap().setString("usemap", usemap);
	}

	/**
	 * <P>
	 * value °ꤷޤ
	 * </P>
	 * @param value value °
	 */
	public void setValue(String value)
	{
		getAttributeMap().setString("value", value);
	}

	/**
	 * <P>
	 * template °ꤷޤ
	 * </P>
	 * @param template template °
	 */
	public void setTemplate(String template)
	{
		getAttributeMap().setString("template", template);
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		//INPUTޤ
		StringBuffer buf = new StringBuffer();
		buf.append("<input");

		//TagTemplateޤ
		TagManager tm = this.getTagManager();
		TagTemplate ttmp = null;
		if (this.getAttributeMap().containsKey("template"))
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getTemplate());
		}
		else
		{
			ttmp = tm.getTagTemplate(this.getTagType(), this.getName());
		}

		ConversionMap attr = new ConversionMap();
		if (ttmp != null)
		{
			attr.putAll(ttmp.getAttributeMap());
		}
		attr.putAll(this.getAttributeMap());

		String keys[] = new String[attr.size()];
		keys = (String[])attr.keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			if (keys[i].equals("template"))
			{
				//⤷ʤ
			}
			else if (keys[i].equals("disabled") ||
					keys[i].equals("readonly") ||
					keys[i].equals("checked") ||
					keys[i].equals("ismap"))
			{
				if (attr.getBoolean(keys[i]))
				{
					buf.append(" ").append(keys[i]);
				}
			}
			else if (keys[i].equals("value"))
			{
				HtmlEncoder encoder = tm.getHtmlEncoder();
				buf.append(" ").append(keys[i]).append("=\"").append(encoder.encode(attr.getString(keys[i]))).append("\"");
			}
			else
			{
				buf.append(" ").append(keys[i]).append("=\"").append(attr.getString(keys[i])).append("\"");
			}
		}
		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

	/**
	 * <P>
	 * ΥΥפ֤ޤ
	 * </P>
	 * @return ΥΥ
	 * @see jp.morpho.webapp.servlet.jsp.tagext.TagTemplate#getTagType()
	 */
	public abstract String getTagType();

	/**
	 * <P>
	 * checked °ꤵʤä硢name °ꤵƤ̾򥭡ˤ HTTP ѥ᡼ͤchecked °ꤷޤ
	 * name °ꤵƤʤϲ⤷ޤ
	 * </P>
	 */
	protected void setCheckedByFormData()
	{
		if (!this.getAttributeMap().containsKey("checked") && this.getAttributeMap().containsKey("name"))
		{
			HttpActionRequest req = new HttpActionRequest((HttpServletRequest)pageContext.getRequest());
			ConversionMap param = ConversionMap.valueOf(req.getParameterMap());
			if (!param.isNull(this.getName()))
			{
				if (param.isArray(this.getName()))
				{
					String values[] = (String[])param.getObject(this.getName());
					String val = this.getValue();
					for (int i = 0; i < values.length; i++)
					{
						if (val.equals(values[i]))
						{
							this.setChecked(true);
							break;
						}
					}
				}
				else
				{
					if (this.getValue().equals(param.getString(this.getName())))
					{
						this.setChecked(true);
					}
				}
			}
		}
	}

	/**
	 * <P>
	 * value °ꤵʤä硢name °ꤵƤ̾򥭡ˤ HTTP ѥ᡼ͤvalue °ꤷޤ
	 * name °ꤵƤʤϲ⤷ޤ
	 * </P>
	 */
	protected void setValueByFormData()
	{
		if (!this.getAttributeMap().containsKey("value") && this.getAttributeMap().containsKey("name"))
		{
			HttpActionRequest req = new HttpActionRequest((HttpServletRequest)pageContext.getRequest());
			ConversionMap param = ConversionMap.valueOf(req.getParameterMap());
			if (param.containsKey(this.getName()))
			{
				this.getAttributeMap().setString("value", param.getString(this.getName()));
			}
		}
	}

}
