/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class DateValidator
extends AbstractFieldValidator {
    private String pattern = null;
    private Date minimum = null;
    private Date maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        if (this.pattern == null) {
            throw new ValidationException("pattern is not set");
        }
        String value = request.getParameter(this.getFieldName());
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern);
        Date date = null;
        try {
            date = dateFormat.parse(value);
            if (date == null) {
                throw new ValidationException("value is not date");
            }
        }
        catch (Exception e) {
            throw new ValidationException("value is not date");
        }
        if (this.minimum != null && this.minimum.compareTo(date) < 0) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum.compareTo(date) > 0) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
            Date compareValue = form.parseDate(this.getCompareFieldName(), this.pattern);
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">") ? date.compareTo(compareValue) <= 0 : (ope.equals(">=") ? date.compareTo(compareValue) < 0 : (ope.equals("==") ? date.compareTo(compareValue) != 0 : (ope.equals("<=") ? date.compareTo(compareValue) > 0 : (ope.equals("<") ? date.compareTo(compareValue) >= 0 : ope.equals("!=") && date.compareTo(compareValue) == 0))))) {
                throw new ValidationException("compare error");
            }
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String value) {
        this.pattern = value;
    }

    public void setMinimum(Date value) throws ValidationException {
        this.minimum = value;
    }

    public void setMaximum(Date value) throws ValidationException {
        this.maximum = value;
    }

    public Date getMaximum() {
        return this.maximum;
    }

    public Date getMinimum() {
        return this.minimum;
    }
}

