/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class LengthValidator
extends AbstractFieldValidator {
    private Integer minimum = null;
    private Integer maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = request.getParameter(this.getFieldName());
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        int bytes = value.getBytes().length;
        if (this.minimum != null && this.minimum > bytes) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < bytes) {
            throw new ValidationException("out of range");
        }
    }

    public void setMinimum(int value) throws ValidationException {
        this.minimum = new Integer(value);
    }

    public void setMaximum(int value) throws ValidationException {
        this.maximum = new Integer(value);
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }
}

