/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.morpho.webapp.action.AbstractActionMappingManager;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionMappingNotFoundException;

/**
 * <P>
 * ActionMappingManager ̎łB
 * ftHg̃ANV}bsO}l[WŁAActionMappingManager ̊{܂B
 * KvȂ΁ÃNXg邩A܂͐V ActionMappingManager ēƎ̃ANV}bsO}l[W쐬邱Ƃł܂B
 * </P>
 * <P>
 * V ActionMappingManager ꍇ́AAbstractActionMappingManager NXgĕKvȃ\bh܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionMappingManagerImpl
	extends AbstractActionMappingManager
{

	/** vXe[^X̃p[^̖O */
	private String statusParameterName = null;

	/** vANṼp[^̖O */
	private String actionParameterName = null;

	/** v󂯎T[ubg̃pX̃}bv */
	private Map actionServletPaths = new HashMap();

	/**
	 * <P>
	 * ActionMappingManagerImpl 쐬܂B
	 * </P>
	 */
	public ActionMappingManagerImpl()
	{
		super();
	}

	/**
	 * <P>
	 * vXe[^X̃p[^̖OԂ܂B
	 * </P>
	 * @return vXe[^X̃p[^̖O
	 * @see jp.morpho.webapp.action.ActionMappingManager#getStatusParameterName()
	 */
	public synchronized String getStatusParameterName()
	{
		return statusParameterName;
	}

	/**
	 * <P>
	 * vXe[^X̃p[^̖Oݒ肵܂B
	 * </P>
	 * @param statusParameterName vXe[^X̃p[^̖O
	 */
	public synchronized void setStatusParameterName(String statusParameterName)
	{
		this.statusParameterName = statusParameterName;
	}

	/**
	 * <P>
	 * vANṼp[^̖OԂ܂B
	 * </P>
	 * @return vANṼp[^̖O
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionParameterName()
	 */
	public synchronized String getActionParameterName()
	{
		return actionParameterName;
	}

	/**
	 * <P>
	 * vANṼp[^̖Oݒ肵܂B
	 * </P>
	 * @param actionParameterName vANṼp[^̖O
	 */
	public synchronized void setActionParameterName(String actionParameterName)
	{
		this.actionParameterName = actionParameterName;
	}

	/**
	 * <P>
	 * ANVnh`FCԂ܂B
	 * ANVnh`FĆAActionMappingManager  getActionHandlers(String, String, String) \bh getActionView(String, String) \bhĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh`FC
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlerChain(String, String, String)
	 */
	public synchronized ActionHandlerChain getActionHandlerChain(
		String servletPath,
		String status,
		String action)
	{
		return new ActionHandlerChainImpl(this, servletPath, status, action);
	}

	/**
	 * <P>
	 * ANVnh̔zԂ܂B
	 * ԂꂽANVnh̔źAANVnh`FC doActionHandler \bhŏɌĂяo܂B
	 * </P>
	 * <P>
	 * ̃\bh́AvANVnh擾邽߂ɁAANVnh`FCĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh̔z
	 * @exception ActionMappingNotFoundException NCAgĂяoꂽT[ubg URL AXe[^XAANVgpăANV}bsO擾悤ƂAΉANV}bsO̒`Ȃꍇ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlers(String, String, String)
	 */
	public synchronized ActionHandler[] getActionHandlers(
		String servletPath,
		String status,
		String action)
		throws ActionMappingNotFoundException
	{
		//v󂯎T[ubg̃pX}bsO擾܂
		//擾łȂꍇ́ÃANVnh̔zԂ܂
		ActionServletPath asp = getActionServletPath(servletPath);
		if (asp == null)
		{
			return new ActionHandler[0];
		}

		//ANVnh̃Gg}bsO擾܂
		//擾łȂꍇ́ÃANVnh̔zԂ܂
		ActionHandlerEntry entry = asp.getActionHandlerEntry(status, action);
		if (entry == null || entry.size() == 0)
		{
			return new ActionHandler[0];
		}

		//ANVnhNX[hāAANVnh̔zԂ܂
		ArrayList actionHandlers = new ArrayList();
		for (int i = 0; i < entry.size(); i++)
		{
			String className = (String)entry.get(i);
			try
			{
				ClassLoader cl = Thread.currentThread().getContextClassLoader();
				if (cl == null)
				{
					cl = getClass().getClassLoader();
				}
				actionHandlers.add((ActionHandler)cl.loadClass(className).newInstance());
			}
			catch (Exception e)
			{
				throw new ActionMappingNotFoundException(e.getMessage());
			}
		}
		return (ActionHandler[])actionHandlers.toArray(new ActionHandler[actionHandlers.size()]);
	}

	/**
	 * <P>
	 * ANVr[̃pX (JSP Ȃ) Ԃ܂B
	 * ANVr[́AANVnh`FC doActionHandler \bhŁAANVnhĂяoꂽAɃCN[h܂B
	 * </P>
	 * <P>
	 * Xe[^X̒ĺAANVnhŕύX邱Ƃ邽߁AT[ubgv󂯎̒lƕKv܂B
	 * ̃\bh́AANVnh`FC doActionHandler \bhŁAׂẴANVnhsꂽɌĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @return ANVr[̃pX
	 * @exception ActionMappingNotFoundException NCAgĂяoꂽT[ubg URL AXe[^XgpăANV}bsO擾悤ƂAΉANV}bsO̒`Ȃꍇ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionView(String, String)
	 */
	public synchronized String getActionView(String servletPath, String status)
		throws ActionMappingNotFoundException
	{
		//v󂯎T[ubg̃pX}bsO擾܂
		//擾łȂꍇ́AOX[܂
		ActionServletPath asp = getActionServletPath(servletPath);
		if (asp == null)
		{
			StringBuffer msg = new StringBuffer();
			msg.append("servletPath not found: ");
			msg.append("servletPath=");
			msg.append(servletPath);
			msg.append(",status=");
			msg.append(status);
			throw new ActionMappingNotFoundException(msg.toString());
		}

		//ANVr[̃Gg}bsO擾܂
		//擾łȂꍇ́AOX[܂
		ActionViewEntry entry = asp.getActionViewEntry(status);
		if (entry == null)
		{
			StringBuffer msg = new StringBuffer();
			msg.append("ActionViewEntry not found: ");
			msg.append("servletPath=");
			msg.append(servletPath);
			msg.append(",status=");
			msg.append(status);
			throw new ActionMappingNotFoundException(msg.toString());
		}

		//ANVr[̃pXԂ܂
		return entry.getPath();
	}

	/**
	 * <P>
	 * vT[ubg̃pX̃GgɎw̃Ggǉ܂B
	 * </P>
	 * @param asp vT[ubg̃pX̃GgɒǉGg
	 * @exception IllegalArgumentException pX̃Ggꍇ
	 */
	public synchronized void addActionServletPath(ActionServletPath asp)
	{
		String key = asp.getServletPath();
		if (actionServletPaths.containsKey(key))
		{
			throw new IllegalArgumentException("ActionServletPath already exists: " + key);
		}
		actionServletPaths.put(key, asp);
	}

	/**
	 * <P>
	 * w肳ꂽpX̗vT[ubg̃pX̃GgԂ܂B
	 * </P>
	 * @param servletPath vT[ubg̃pX
	 */
	public synchronized ActionServletPath getActionServletPath(String servletPath)
	{
		return (ActionServletPath)actionServletPaths.get(servletPath);
	}

}
