/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.impl.HttpActionRequestImpl;

/**
 * <P>
 * tB^Ɏw肳ꂽGR[fBOgpāAtH[f[^GR[h܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class CharacterEncodingFilter
	extends AbstractFilter
{
	/** K[ */
	private Logger log = Logger.getLogger("jp.morpho");

	/** GR[fBO ISO 8859-1AeAt@xbg No. 1 */
	private static final String DEFAULT_CHARACTERENCODING_FROM = "ISO8859_1";

	/** GR[fBO Windows { */
	private static final String DEFAULT_CHARACTERENCODING_TO = "Windows-31J";

	/** p[^ GR[fBO */
	private static final String INITPARAM_CHARACTERENCODING = "characterEncoding";

	/**
	 * <P>
	 * CharacterEncodingFilter \z܂B
	 * </P>
	 */
	public CharacterEncodingFilter()
	{
		super();
	}

	/**
	 * <P>
	 * super.init(filterConfig) ĂяoAtB^Ɏw肳ꂽGR[fBOT[ubgReLXgɊi[܂B
	 * tB^ɕGR[fBOw肳ĂȂꍇ́AftHg̕GR[fBOgp܂B
	 * ftHg̕GR[fBÓAWindows-31J łB
	 * </P>
	 * @param filterConfig T[ubgReiɂĎgptB^ݒ̂߂̃IuWFNg
	 * @exception ServletException tB^łȂꍇ
	 * @see javax.servlet.Filter#init(FilterConfig)
	 */
	public void init(FilterConfig filterConfig) throws ServletException
	{
		super.init(filterConfig);

		//GR[fBO擾܂
		ConversionMap parameters = ConversionMap.valueOf(this.getInitParameterMap());
		String characterEncoding = parameters.getString(INITPARAM_CHARACTERENCODING);
		if (characterEncoding == null || characterEncoding.trim().length() == 0)
		{
			characterEncoding = DEFAULT_CHARACTERENCODING_TO;
		}

		//GR[fBO ServletContext Ɋi[܂
		filterConfig.getServletContext().setAttribute(ServletContextAttributeNames.characterEncoding, characterEncoding);
	}

	/**
	 * <P>
	 * tB^Ɏw肳ꂽGR[fBOgpāAtH[f[^GR[h܂B
	 * </P>
	 * @param request NCAgT[ubgɍsv܂ ServletRequest IuWFNg
	 * @param response T[ubgNCAgɑM鉞܂ ServletResponse IuWFNg
	 * @param chain tB^`F[
	 * @exception IOException tB^vƂɁAo̓G[oꂽꍇ
	 * @exception ServletException vłȂꍇ
	 * @see javax.servlet.Filter#doFilter(ServletRequest, ServletResponse, FilterChain)
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException
	{
		log.fine("doFilter");
		String contentType = request.getContentType();
		int contentLength = request.getContentLength();

		HttpActionRequest actioinRequest = new HttpActionRequestImpl((HttpServletRequest)request);

		ConversionMap formValues = (ConversionMap)actioinRequest.getParameterMap();

		Object[] keyNames = formValues.keySet().toArray();
		for (int i = 0; i < keyNames.length; i++)
		{
			String keyName = keyNames[i].toString();

			if (formValues.isArray(keyName))
			{
				Object[] values = (Object[])formValues.getObject(keyName);
				for (int j = 0; j < values.length; j++)
				{
					if (values[j] instanceof String)
					{
						values[j] = encode((String)values[j]);
					}
				}
				formValues.putObject(keyName, values);
			}
			else if (formValues.getObject(keyName) instanceof String)
			{
				formValues.putString(keyName, encode(formValues.getString(keyName)));
			}
		}
		chain.doFilter(request, response);
	}

	/**
	 * <P>
	 * tB^Ɏw肳ꂽGR[fBOgpāAw肳ꂽGR[fBO܂B
	 * tB^ɕGR[fBOw肳ĂȂꍇ́AftHg̕GR[fBOgp܂B
	 * </P>
	 * @param value GR[fBO镶
	 * @exception UnsupportedEncodingException tB^Ɏw肳ꂽGR[fBOT|[gĂȂꍇ
	 * @return GR[fBOꂽ
	 */
	private String encode(String value) throws UnsupportedEncodingException
	{
		String encodingValue = null;

		//tB^Ɏw肳ꂽGR[fBOgpāAGR[h܂
		encodingValue = (value == null) ? null : new String(value.getBytes(DEFAULT_CHARACTERENCODING_FROM), (String)getServletContext().getAttribute(ServletContextAttributeNames.characterEncoding));

		return encodingValue;
	}

}
