/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.http;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * <P>
 * HttpServletRequest C^tF[XgāAHTTP T[ubgp̗v񋟂܂B
 * </P>
 * <P>
 * HttpActionRequest C^tF[Xɂ́Av邽߂ɕKvȃANVXe[^X擾邽߂̃\bh`܂B
 * </P>
 * @author Kenichi Fukuda
 */
public interface HttpActionRequest
	extends HttpServletRequest
{

	/**
	 * <P>
	 * vANV̒l擾܂B
	 * </P>
	 * @return vANV̒l
	 */
	public String getAction();

	/**
	 * <P>
	 * vANV̒lݒ肵܂B
	 * </P>
	 * @param action vANV̒l
	 */
	public void setAction(String action);

	/**
	 * <P>
	 * vXe[^X̒l擾܂B
	 * </P>
	 * @return vXe[^X̒l
	 */
	public String getStatus();

	/**
	 * <P>
	 * vXe[^X̒lݒ肵܂B
	 * </P>
	 * @param status vXe[^X̒l
	 */
	public void setStatus(String status);

	/**
	 * <P>
	 * ̗vɃp[^ݒ肵܂B
	 * </P>
	 * @param map vp[^
	 */
	public void setParameterMap(Map map);

	/**
	 * <P>
	 * ̗vɃp[^̃}bvꍇɁÃp[^̃}bvv폜܂B<br>
	 * </P>
	 */
	public void removeParameterMap();

}
