/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.bean;

import java.util.Date;

import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;

/**
 * 勤怠関連申請承認インターフェース。<br>
 */
public interface TimeApprovalBeanInterface {
	
	/**
	 * 承認処理を行う。<br>
	 * @param workflow ワークフロー番号
	 * @param workflowComment ワークフローコメント
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void approve(long workflow, String workflowComment) throws MospException;
	
	/**
	 * 一括承認処理を行う。<br>
	 * @param aryWorkflow ワークフロー番号配列
	 * @param workflowComment ワークフローコメント
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void approve(long[] aryWorkflow, String workflowComment) throws MospException;
	
	/**
	 * 差戻処理を行う。<br>
	 * @param workflow ワークフロー番号
	 * @param workflowComment ワークフローコメント
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void revert(long workflow, String workflowComment) throws MospException;
	
	/**
	 * 承認解除処理を行う。<br>
	 * @param workflow ワークフロー番号
	 * @param workflowComment ワークフローコメント
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void cancel(long workflow, String workflowComment) throws MospException;
	
	/**
	 * 承認時の確認処理を行う。<br>
	 * 申請カテゴリに応じた承認時の確認処理を行う。<br>
	 * @param dto 対象DTO
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void checkApproval(BaseDtoInterface dto) throws MospException;
	
	/**
	 * 解除時の確認処理を行う。<br>
	 * 申請カテゴリに応じた解除時の確認処理を行う。<br>
	 * @param dto 対象DTO
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void checkCancel(BaseDtoInterface dto) throws MospException;
	
	/**
	 * 勤怠を下書し直す。<br>
	 * @param personalId 個人ID
	 * @param workDate 勤務日
	 * @throws MospException インスタンスの取得及びSQL実行に失敗した場合
	 */
	void reDraft(String personalId, Date workDate) throws MospException;
	
}
