/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.util.List;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.filters.CsvExpressions;
import jp.sf.orangesignal.csv.filters.CsvNamedValueAndExpression;
import jp.sf.orangesignal.csv.filters.CsvNamedValueFilter;
import jp.sf.orangesignal.csv.filters.CsvNamedValueLogicalExpression;

public class SimpleCsvNamedValueFilter
implements CsvNamedValueFilter {
    private CsvNamedValueLogicalExpression expr;

    public SimpleCsvNamedValueFilter() {
        this(new CsvNamedValueAndExpression());
    }

    public SimpleCsvNamedValueFilter(CsvNamedValueLogicalExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("%s must not be null", CsvNamedValueLogicalExpression.class.getSimpleName()));
        }
        this.expr = expr;
    }

    public SimpleCsvNamedValueFilter add(CsvNamedValueFilter filter) {
        this.expr.add(filter);
        return this;
    }

    public SimpleCsvNamedValueFilter isNull(int position) {
        this.expr.add(CsvExpressions.isNull(position));
        return this;
    }

    public SimpleCsvNamedValueFilter isNull(String name) {
        this.expr.add(CsvExpressions.isNull(name));
        return this;
    }

    public SimpleCsvNamedValueFilter isNotNull(int position) {
        this.expr.add(CsvExpressions.isNotNull(position));
        return this;
    }

    public SimpleCsvNamedValueFilter isNotNull(String name) {
        this.expr.add(CsvExpressions.isNotNull(name));
        return this;
    }

    public SimpleCsvNamedValueFilter isEmpty(int position) {
        this.expr.add(CsvExpressions.isEmpty(position));
        return this;
    }

    public SimpleCsvNamedValueFilter isEmpty(String name) {
        this.expr.add(CsvExpressions.isEmpty(name));
        return this;
    }

    public SimpleCsvNamedValueFilter isNotEmpty(int position) {
        this.expr.add(CsvExpressions.isNotEmpty(position));
        return this;
    }

    public SimpleCsvNamedValueFilter isNotEmpty(String name) {
        this.expr.add(CsvExpressions.isNotEmpty(name));
        return this;
    }

    public SimpleCsvNamedValueFilter eq(int position, String criteria) {
        this.expr.add(CsvExpressions.eq(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter eq(String name, String criteria) {
        this.expr.add(CsvExpressions.eq(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter eq(int position, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.eq(position, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter eq(String name, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.eq(name, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter ne(int position, String criteria) {
        this.expr.add(CsvExpressions.ne(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter ne(String name, String criteria) {
        this.expr.add(CsvExpressions.ne(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter ne(int position, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.ne(position, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter ne(String name, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.ne(name, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter in(int position, String ... criterias) {
        this.expr.add(CsvExpressions.in(position, criterias));
        return this;
    }

    public SimpleCsvNamedValueFilter in(String name, String ... criterias) {
        this.expr.add(CsvExpressions.in(name, criterias));
        return this;
    }

    public SimpleCsvNamedValueFilter in(int position, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.in(position, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter in(String name, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.in(name, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter notIn(int position, String ... criterias) {
        this.expr.add(CsvExpressions.notIn(position, criterias));
        return this;
    }

    public SimpleCsvNamedValueFilter notIn(String name, String ... criterias) {
        this.expr.add(CsvExpressions.notIn(name, criterias));
        return this;
    }

    public SimpleCsvNamedValueFilter notIn(int position, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.notIn(position, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter notIn(String name, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.notIn(name, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(int position, String pattern) {
        this.expr.add(CsvExpressions.regex(position, pattern));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(String name, String pattern) {
        this.expr.add(CsvExpressions.regex(name, pattern));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(int position, String pattern, boolean ignoreCase) {
        this.expr.add(CsvExpressions.regex(position, pattern, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(String name, String pattern, boolean ignoreCase) {
        this.expr.add(CsvExpressions.regex(name, pattern, ignoreCase));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(int position, String pattern, int flags) {
        this.expr.add(CsvExpressions.regex(position, pattern, flags));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(String name, String pattern, int flags) {
        this.expr.add(CsvExpressions.regex(name, pattern, flags));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(int position, Pattern pattern) {
        this.expr.add(CsvExpressions.regex(position, pattern));
        return this;
    }

    public SimpleCsvNamedValueFilter regex(String name, Pattern pattern) {
        this.expr.add(CsvExpressions.regex(name, pattern));
        return this;
    }

    public SimpleCsvNamedValueFilter gt(int position, String criteria) {
        this.expr.add(CsvExpressions.gt(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter gt(String name, String criteria) {
        this.expr.add(CsvExpressions.gt(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter lt(int position, String criteria) {
        this.expr.add(CsvExpressions.lt(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter lt(String name, String criteria) {
        this.expr.add(CsvExpressions.lt(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter ge(int position, String criteria) {
        this.expr.add(CsvExpressions.ge(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter ge(String name, String criteria) {
        this.expr.add(CsvExpressions.ge(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter le(int position, String criteria) {
        this.expr.add(CsvExpressions.le(position, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter le(String name, String criteria) {
        this.expr.add(CsvExpressions.le(name, criteria));
        return this;
    }

    public SimpleCsvNamedValueFilter between(int position, String low, String high) {
        this.expr.add(CsvExpressions.between(position, low, high));
        return this;
    }

    public SimpleCsvNamedValueFilter between(String name, String low, String high) {
        this.expr.add(CsvExpressions.between(name, low, high));
        return this;
    }

    public SimpleCsvNamedValueFilter not(CsvNamedValueFilter filter) {
        this.expr.add(CsvExpressions.not(filter));
        return this;
    }

    @Override
    public boolean accept(List<String> header, List<String> values) {
        return this.expr.accept(header, values);
    }

    public String toString() {
        String name = this.getClass().getName();
        int period = name.lastIndexOf(46);
        return period > 0 ? name.substring(period + 1) : name;
    }
}

