/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.gopher;

import gnu.inet.gopher.GopherConnection;
import gnu.inet.gopher.GopherContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public class GopherURLConnection
extends URLConnection {
    protected GopherConnection connection;

    public GopherURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String host = this.url.getHost();
        int port = this.url.getPort();
        this.connection = new GopherConnection(host, port);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        String dir = this.url.getPath();
        String filename = this.url.getFile();
        if (dir == null && filename == null) {
            throw new UnsupportedOperationException("not implemented");
        }
        String selector = dir == null ? filename : dir + '/' + filename;
        return this.connection.get(selector);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public Object getContent() throws IOException {
        return new GopherContentHandler().getContent(this);
    }

    public Object getContent(Class[] classes) throws IOException {
        return new GopherContentHandler().getContent(this, classes);
    }
}

