/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.HTTPDateFormat;
import gnu.inet.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Headers
implements Map {
    static final DateFormat dateFormat = new HTTPDateFormat();
    private LinkedHashMap headers = new LinkedHashMap();

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(new Header((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    public Object get(Object key) {
        return this.headers.get(new Header((String)key));
    }

    public String getValue(String header) {
        return (String)this.headers.get(new Header(header));
    }

    public int getIntValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Date getDateValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return null;
        }
        try {
            return dateFormat.parse(val);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Object put(Object key, Object value) {
        return this.headers.put(new Header((String)key), value);
    }

    public Object remove(Object key) {
        return this.headers.remove(new Header((String)key));
    }

    public void putAll(Map t) {
        for (String key : t.keySet()) {
            String value = (String)t.get(key);
            this.headers.put(new Header(key), value);
        }
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    public Set keySet() {
        Set keys = this.headers.keySet();
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            ret.add(((Header)i.next()).name);
        }
        return ret;
    }

    public Collection values() {
        return this.headers.values();
    }

    public Set entrySet() {
        Set entries = this.headers.entrySet();
        LinkedHashSet<HeaderEntry> ret = new LinkedHashSet<HeaderEntry>();
        for (Map.Entry entry : entries) {
            ret.add(new HeaderEntry(entry));
        }
        return ret;
    }

    @Override
    public boolean equals(Object other) {
        return this.headers.equals(other);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public void parse(InputStream in) throws IOException {
        LineInputStream lin = in instanceof LineInputStream ? (LineInputStream)in : new LineInputStream(in);
        String name = null;
        StringBuffer value = new StringBuffer();
        while (true) {
            String line;
            if ((line = lin.readLine()) == null) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            int len = line.length();
            if (len < 2) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            char c1 = line.charAt(0);
            if (c1 == ' ' || c1 == '\t') {
                value.append(line.substring(0, len - 1));
                continue;
            }
            if (name != null) {
                this.addValue(name, value.toString());
            }
            int di = line.indexOf(58);
            name = line.substring(0, di);
            value.setLength(0);
            while (++di < len && line.charAt(di) == ' ') {
            }
            value.append(line.substring(di, len - 1));
        }
    }

    private void addValue(String name, String value) {
        Header key = new Header(name);
        String old = (String)this.headers.get(key);
        if (old == null) {
            this.headers.put(key, value);
        } else {
            this.headers.put(key, old + ", " + value);
        }
    }

    static class HeaderEntry
    implements Map.Entry {
        final Map.Entry entry;

        HeaderEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return ((Header)this.entry.getKey()).name;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return ((Object)this.entry).hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return ((Object)this.entry).equals(other);
        }

        public String toString() {
            return this.getKey().toString() + "=" + this.getValue();
        }
    }

    static class Header {
        final String name;

        Header(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException(name);
            }
            this.name = name;
        }

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Header) {
                return ((Header)other).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

