/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Authenticator;
import gnu.inet.http.ByteArrayRequestBodyWriter;
import gnu.inet.http.ChunkedInputStream;
import gnu.inet.http.Cookie;
import gnu.inet.http.CookieManager;
import gnu.inet.http.Credentials;
import gnu.inet.http.HTTPConnection;
import gnu.inet.http.HTTPDateFormat;
import gnu.inet.http.Headers;
import gnu.inet.http.RequestBodyWriter;
import gnu.inet.http.Response;
import gnu.inet.http.ResponseBodyReader;
import gnu.inet.http.ResponseHeaderHandler;
import gnu.inet.util.BASE64;
import gnu.inet.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class Request {
    protected final HTTPConnection connection;
    protected final String method;
    protected final String path;
    protected final Headers requestHeaders;
    protected RequestBodyWriter requestBodyWriter;
    protected int requestBodyNegotiationThreshold;
    protected ResponseBodyReader responseBodyReader;
    protected Map responseHeaderHandlers;
    protected Authenticator authenticator;
    private boolean dispatched;
    byte[] nonce;

    protected Request(HTTPConnection connection, String method, String path) {
        this.connection = connection;
        this.method = method;
        this.path = path;
        this.requestHeaders = new Headers();
        this.responseHeaderHandlers = new HashMap();
        this.requestBodyNegotiationThreshold = 4096;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestURI() {
        return this.connection.getURI() + this.path;
    }

    public Headers getHeaders() {
        return this.requestHeaders;
    }

    public String getHeader(String name) {
        return this.requestHeaders.getValue(name);
    }

    public int getIntHeader(String name) {
        return this.requestHeaders.getIntValue(name);
    }

    public Date getDateHeader(String name) {
        return this.requestHeaders.getDateValue(name);
    }

    public void setHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public void setRequestBody(byte[] requestBody) {
        this.setRequestBodyWriter(new ByteArrayRequestBodyWriter(requestBody));
    }

    public void setRequestBodyWriter(RequestBodyWriter requestBodyWriter) {
        this.requestBodyWriter = requestBodyWriter;
    }

    public void setResponseBodyReader(ResponseBodyReader responseBodyReader) {
        this.responseBodyReader = responseBodyReader;
    }

    public void setResponseHeaderHandler(String name, ResponseHeaderHandler handler) {
        this.responseHeaderHandlers.put(name, handler);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setRequestBodyNegotiationThreshold(int threshold) {
        this.requestBodyNegotiationThreshold = threshold;
    }

    public Response dispatch() throws IOException {
        Response response;
        if (this.dispatched) {
            throw new ProtocolException("request already dispatched");
        }
        String CRLF = "\r\n";
        String HEADER_SEP = ": ";
        String US_ASCII = "US-ASCII";
        String version = this.connection.getVersion();
        int contentLength = -1;
        boolean retry = false;
        int attempts = 0;
        boolean expectingContinue = false;
        if (this.requestBodyWriter != null) {
            contentLength = this.requestBodyWriter.getContentLength();
            if (contentLength > this.requestBodyNegotiationThreshold) {
                expectingContinue = true;
                this.setHeader("Expect", "100-continue");
            } else {
                this.setHeader("Content-Length", Integer.toString(contentLength));
            }
        }
        try {
            do {
                retry = false;
                this.connection.fireRequestEvent(1, this);
                OutputStream out = this.connection.getOutputStream();
                LineInputStream in = new LineInputStream(this.connection.getInputStream());
                String requestUri = this.path;
                if (this.connection.isUsingProxy() && !"*".equals(requestUri) && !"CONNECT".equals(this.method)) {
                    requestUri = this.getRequestURI();
                }
                String line = this.method + ' ' + requestUri + ' ' + version + "\r\n";
                out.write(line.getBytes("US-ASCII"));
                for (String name : this.requestHeaders.keySet()) {
                    String value = (String)this.requestHeaders.get(name);
                    line = name + ": " + value + "\r\n";
                    out.write(line.getBytes("US-ASCII"));
                }
                out.write("\r\n".getBytes("US-ASCII"));
                if (this.requestBodyWriter != null && !expectingContinue) {
                    int len;
                    byte[] buffer = new byte[4096];
                    int count = 0;
                    this.requestBodyWriter.reset();
                    do {
                        if ((len = this.requestBodyWriter.write(buffer)) <= 0) continue;
                        out.write(buffer, 0, len);
                    } while (len > -1 && (count += len) < contentLength);
                    out.write("\r\n".getBytes("US-ASCII"));
                }
                out.flush();
                this.connection.fireRequestEvent(2, this);
                response = this.readResponse(in);
                int sc = response.getCode();
                if (sc == 401 && this.authenticator != null) {
                    if (!this.authenticate(response, attempts++)) continue;
                    retry = true;
                    continue;
                }
                if (sc != 100 || !expectingContinue) continue;
                this.requestHeaders.remove("Expect");
                this.setHeader("Content-Length", Integer.toString(contentLength));
                expectingContinue = false;
                retry = true;
            } while (retry);
        }
        catch (IOException e) {
            this.connection.close();
            throw e;
        }
        return response;
    }

    Response readResponse(LineInputStream in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            throw new ProtocolException("Peer closed connection");
        }
        if (!line.startsWith("HTTP/")) {
            throw new ProtocolException(line);
        }
        int len = line.length();
        int start = 5;
        int end = 6;
        while (line.charAt(end) != '.') {
            ++end;
        }
        int majorVersion = Integer.parseInt(line.substring(start, end));
        start = end + 1;
        end = start + 1;
        while (line.charAt(end) != ' ') {
            ++end;
        }
        int minorVersion = Integer.parseInt(line.substring(start, end));
        start = end + 1;
        end = start + 3;
        int code = Integer.parseInt(line.substring(start, end));
        String message = line.substring(end + 1, len - 1);
        Headers responseHeaders = new Headers();
        responseHeaders.parse(in);
        this.notifyHeaderHandlers(responseHeaders);
        int codeClass = code / 100;
        Response ret = new Response(majorVersion, minorVersion, code, codeClass, message, responseHeaders);
        if (!"HEAD".equals(this.method) && !"OPTIONS".equals(this.method)) {
            switch (code) {
                case 204: 
                case 205: {
                    break;
                }
                default: {
                    boolean notify;
                    boolean bl = notify = this.responseBodyReader != null;
                    if (notify && !this.responseBodyReader.accept(this, ret)) {
                        notify = false;
                    }
                    this.readResponseBody(ret, in, notify);
                }
            }
        }
        return ret;
    }

    void notifyHeaderHandlers(Headers headers) {
        for (Map.Entry entry : headers.entrySet()) {
            ResponseHeaderHandler handler;
            String name = (String)entry.getKey();
            if ("Set-Cookie".equalsIgnoreCase(name)) {
                String value = (String)entry.getValue();
                this.handleSetCookie(value);
            }
            if ((handler = (ResponseHeaderHandler)this.responseHeaderHandlers.get(name)) == null) continue;
            String value = (String)entry.getValue();
            handler.setValue(value);
        }
    }

    void readResponseBody(Response response, InputStream in, boolean notify) throws IOException {
        Headers trailer;
        block13: {
            boolean doClose;
            int contentLength;
            byte[] buffer;
            block12: {
                buffer = new byte[4096];
                contentLength = -1;
                trailer = null;
                String transferCoding = response.getHeader("Transfer-Encoding");
                if ("chunked".equalsIgnoreCase(transferCoding)) {
                    trailer = new Headers();
                    in = new ChunkedInputStream(in, trailer);
                } else {
                    contentLength = response.getIntHeader("Content-Length");
                }
                String contentCoding = response.getHeader("Content-Encoding");
                if (contentCoding != null && !"identity".equals(contentCoding)) {
                    if ("gzip".equals(contentCoding)) {
                        in = new GZIPInputStream(in);
                    } else if ("deflate".equals(contentCoding)) {
                        in = new InflaterInputStream(in);
                    } else {
                        throw new ProtocolException("Unsupported Content-Encoding: " + contentCoding);
                    }
                }
                boolean bl = doClose = "close".equalsIgnoreCase(this.getHeader("Connection")) || "close".equalsIgnoreCase(response.getHeader("Connection")) || this.connection.majorVersion == 1 && this.connection.minorVersion == 0 || response.majorVersion == 1 && response.minorVersion == 0 || contentLength == -1;
                if (contentLength != 0) break block12;
                if (!doClose) break block13;
                this.connection.closeConnection();
                break block13;
            }
            int count = contentLength;
            int len = count > -1 ? count : buffer.length;
            int n = len = len > buffer.length ? buffer.length : len;
            while (len > -1) {
                if ((len = in.read(buffer, 0, len)) < 0) {
                    this.connection.closeConnection();
                    break;
                }
                if (notify) {
                    this.responseBodyReader.read(buffer, 0, len);
                }
                if (count <= -1 || (count -= len) >= 1) continue;
                if (!doClose) break;
                this.connection.closeConnection();
                break;
            }
        }
        if (notify) {
            this.responseBodyReader.close();
        }
        if (trailer != null) {
            response.getHeaders().putAll((Map)trailer);
            this.notifyHeaderHandlers(trailer);
        }
    }

    boolean authenticate(Response response, int attempts) throws IOException {
        int si;
        String scheme;
        String challenge = response.getHeader("WWW-Authenticate");
        if (challenge == null) {
            challenge = response.getHeader("Proxy-Authenticate");
        }
        String string = scheme = (si = challenge.indexOf(32)) == -1 ? challenge : challenge.substring(0, si);
        if ("Basic".equalsIgnoreCase(scheme)) {
            Properties params = this.parseAuthParams(challenge.substring(si + 1));
            String realm = params.getProperty("realm");
            Credentials creds = this.authenticator.getCredentials(realm, attempts);
            String userPass = creds.getUsername() + ':' + creds.getPassword();
            byte[] b_userPass = userPass.getBytes("US-ASCII");
            byte[] b_encoded = BASE64.encode(b_userPass);
            String authorization = scheme + " " + new String(b_encoded, "US-ASCII");
            this.setHeader("Authorization", authorization);
            return true;
        }
        if ("Digest".equalsIgnoreCase(scheme)) {
            Properties params = this.parseAuthParams(challenge.substring(si + 1));
            String realm = params.getProperty("realm");
            String nonce = params.getProperty("nonce");
            String qop = params.getProperty("qop");
            String algorithm = params.getProperty("algorithm");
            String digestUri = this.getRequestURI();
            Credentials creds = this.authenticator.getCredentials(realm, attempts);
            String username = creds.getUsername();
            String password = creds.getPassword();
            this.connection.incrementNonce(nonce);
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] COLON = new byte[]{58};
                md5.reset();
                md5.update(username.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(realm.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(password.getBytes("US-ASCII"));
                byte[] ha1 = md5.digest();
                if ("md5-sess".equals(algorithm)) {
                    byte[] cnonce = this.generateNonce();
                    md5.reset();
                    md5.update(ha1);
                    md5.update(COLON);
                    md5.update(nonce.getBytes("US-ASCII"));
                    md5.update(COLON);
                    md5.update(cnonce);
                    ha1 = md5.digest();
                }
                String ha1Hex = this.toHexString(ha1);
                md5.reset();
                md5.update(this.method.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(digestUri.getBytes("US-ASCII"));
                if ("auth-int".equals(qop)) {
                    byte[] hEntity = null;
                    md5.update(COLON);
                    md5.update(hEntity);
                }
                byte[] ha2 = md5.digest();
                String ha2Hex = this.toHexString(ha2);
                md5.reset();
                md5.update(ha1Hex.getBytes("US-ASCII"));
                md5.update(COLON);
                md5.update(nonce.getBytes("US-ASCII"));
                if ("auth".equals(qop) || "auth-int".equals(qop)) {
                    String nc = this.getNonceCount(nonce);
                    byte[] cnonce = this.generateNonce();
                    md5.update(COLON);
                    md5.update(nc.getBytes("US-ASCII"));
                    md5.update(COLON);
                    md5.update(cnonce);
                    md5.update(COLON);
                    md5.update(qop.getBytes("US-ASCII"));
                }
                md5.update(COLON);
                md5.update(ha2Hex.getBytes("US-ASCII"));
                String digestResponse = this.toHexString(md5.digest());
                String authorization = scheme + " username=\"" + username + "\"" + " realm=\"" + realm + "\"" + " nonce=\"" + nonce + "\"" + " uri=\"" + digestUri + "\"" + " response=\"" + digestResponse + "\"";
                this.setHeader("Authorization", authorization);
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
        }
        return false;
    }

    Properties parseAuthParams(String text) {
        int len = text.length();
        String key = null;
        StringBuffer buf = new StringBuffer();
        Properties ret = new Properties();
        boolean inQuote = false;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c == '=' && key == null) {
                key = buf.toString().trim();
                buf.setLength(0);
                continue;
            }
            if (c == ' ' && !inQuote) {
                String value = this.unquote(buf.toString().trim());
                ret.put(key, value);
                key = null;
                buf.setLength(0);
                continue;
            }
            if (c == ',' && (i >= len - 1 || text.charAt(i + 1) == ' ')) continue;
            buf.append(c);
        }
        if (key != null) {
            String value = this.unquote(buf.toString().trim());
            ret.put(key, value);
        }
        return ret;
    }

    String unquote(String text) {
        int len = text.length();
        if (len > 0 && text.charAt(0) == '\"' && text.charAt(len - 1) == '\"') {
            return text.substring(1, len - 1);
        }
        return text;
    }

    String getNonceCount(String nonce) {
        int nc = this.connection.getNonceCount(nonce);
        String hex = Integer.toHexString(nc);
        StringBuffer buf = new StringBuffer();
        for (int i = 8 - hex.length(); i > 0; --i) {
            buf.append('0');
        }
        buf.append(hex);
        return buf.toString();
    }

    byte[] generateNonce() throws IOException, NoSuchAlgorithmException {
        if (this.nonce == null) {
            long time = System.currentTimeMillis();
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(Long.toString(time).getBytes("US-ASCII"));
            this.nonce = md5.digest();
        }
        return this.nonce;
    }

    String toHexString(byte[] bytes) {
        char[] ret = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i];
            if (c < 0) {
                c += 256;
            }
            ret[j++] = Character.forDigit(c / 16, 16);
            ret[j++] = Character.forDigit(c % 16, 16);
        }
        return new String(ret);
    }

    void handleSetCookie(String text) {
        CookieManager cookieManager = this.connection.getCookieManager();
        if (cookieManager == null) {
            return;
        }
        String name = null;
        String value = null;
        String comment = null;
        String domain = this.connection.getHostName();
        String path = this.path;
        int lsi = path.lastIndexOf(47);
        if (lsi != -1) {
            path = path.substring(0, lsi);
        }
        boolean secure = false;
        Date expires = null;
        int len = text.length();
        String attr = null;
        StringBuffer buf = new StringBuffer();
        boolean inQuote = false;
        for (int i = 0; i <= len; ++i) {
            char c;
            char c2 = c = i == len ? (char)'\u0000' : text.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote) {
                if (c == '=' && attr == null) {
                    attr = buf.toString().trim();
                    buf.setLength(0);
                    continue;
                }
                if (c == ';' || i == len || c == ',') {
                    String val = this.unquote(buf.toString().trim());
                    if (name == null) {
                        name = attr;
                        value = val;
                    } else if ("Comment".equalsIgnoreCase(attr)) {
                        comment = val;
                    } else if ("Domain".equalsIgnoreCase(attr)) {
                        domain = val;
                    } else if ("Path".equalsIgnoreCase(attr)) {
                        path = val;
                    } else if ("Secure".equalsIgnoreCase(val)) {
                        secure = true;
                    } else if ("Max-Age".equalsIgnoreCase(attr)) {
                        int delta = Integer.parseInt(val);
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeInMillis(System.currentTimeMillis());
                        cal.add(13, delta);
                        expires = cal.getTime();
                    } else if ("Expires".equalsIgnoreCase(attr)) {
                        HTTPDateFormat dateFormat = new HTTPDateFormat();
                        try {
                            expires = dateFormat.parse(val);
                        }
                        catch (ParseException e) {
                            buf.append(c);
                            continue;
                        }
                    }
                    attr = null;
                    buf.setLength(0);
                    if (i == len || c == ',') {
                        Cookie cookie = new Cookie(name, value, comment, domain, path, secure, expires);
                        cookieManager.setCookie(cookie);
                    }
                    if (c != ',') continue;
                    name = null;
                    value = null;
                    comment = null;
                    domain = this.connection.getHostName();
                    path = this.path;
                    if (lsi != -1) {
                        path = path.substring(0, lsi);
                    }
                    secure = false;
                    expires = null;
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
    }
}

