/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.ActiveTime;
import gnu.inet.nntp.LineIterator;
import gnu.inet.nntp.NNTPConnection;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.NoSuchElementException;

public class ActiveTimesIterator
extends LineIterator {
    ActiveTimesIterator(NNTPConnection connection) {
        super(connection);
    }

    @Override
    public Object next() {
        try {
            return this.nextGroup();
        }
        catch (IOException e) {
            throw new NoSuchElementException("I/O error: " + e.getMessage());
        }
    }

    public ActiveTime nextGroup() throws IOException {
        String line = this.nextLine();
        try {
            int start = 0;
            int end = line.indexOf(32, start);
            String group = line.substring(start, end);
            start = end + 1;
            end = line.indexOf(32, start);
            Date time = this.connection.parseDate(line.substring(start, end));
            start = end + 1;
            String email = line.substring(start);
            return new ActiveTime(group, time, email);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
    }
}

