/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.Newsrc;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FileNewsrc
implements Newsrc {
    private static final String NEWSRC_ENCODING = "US-ASCII";
    protected File file;
    protected List subs = null;
    protected List groups = null;
    protected Map lines = null;
    protected boolean dirty;
    protected boolean debug;

    public FileNewsrc(File file, boolean debug) {
        this.file = file;
        this.debug = debug;
    }

    @Override
    public void close() {
        if (!this.dirty) {
            return;
        }
        this.save();
    }

    void load() {
        long max;
        long fs = this.file.length();
        int bs = (int)(fs > (max = Integer.MAX_VALUE) ? max : fs);
        this.groups = new LinkedList();
        this.lines = new HashMap(bs / 20);
        this.subs = new LinkedList();
        try {
            long t1 = System.currentTimeMillis();
            if (this.debug) {
                System.err.println("DEBUG: nntp: newsrc loading " + this.file.getPath());
            }
            FileInputStream fr = new FileInputStream(this.file);
            InputStreamReader ir = new InputStreamReader((InputStream)fr, NEWSRC_ENCODING);
            BufferedReader reader = new BufferedReader(ir, bs);
            String line = reader.readLine();
            while (line != null) {
                int cp = line.indexOf(58);
                if (cp > -1) {
                    String tail;
                    String name = line.substring(0, cp);
                    this.groups.add(name);
                    this.subs.add(name);
                    if (++cp < line.length() && (tail = line.substring(cp).trim()).length() > 0) {
                        this.lines.put(name, tail);
                    }
                } else {
                    int pp = line.indexOf(33);
                    if (pp > -1) {
                        String tail;
                        String name = line.substring(0, pp);
                        this.groups.add(name);
                        if (++pp < line.length() && (tail = line.substring(pp).trim()).length() > 0) {
                            this.lines.put(name, tail);
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            long t2 = System.currentTimeMillis();
            if (this.debug) {
                System.err.println("DEBUG: nntp: newsrc load: " + this.groups.size() + " groups in " + (t2 - t1) + "ms");
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.err.println("WARNING: nntp: unable to read newsrc file");
            if (this.debug) {
                e.printStackTrace(System.err);
            }
        }
        catch (SecurityException e) {
            System.err.println("WARNING: nntp: no read permission on newsrc file");
        }
        this.dirty = false;
    }

    void save() {
        block10: {
            try {
                long t1 = System.currentTimeMillis();
                if (this.debug) {
                    System.err.println("DEBUG: nntp: newsrc saving " + this.file.getPath());
                }
                int bs = this.groups.size() * 20;
                FileOutputStream fw = new FileOutputStream(this.file);
                BufferedOutputStream writer = new BufferedOutputStream(fw, bs);
                for (String group : this.groups) {
                    StringBuffer buffer = new StringBuffer(group);
                    if (this.subs.contains(group)) {
                        buffer.append(':');
                    } else {
                        buffer.append('!');
                    }
                    Object r = this.lines.get(group);
                    if (r instanceof String) {
                        buffer.append((String)r);
                    } else {
                        RangeList ranges = (RangeList)r;
                        if (ranges != null) {
                            buffer.append(ranges.toString());
                        }
                    }
                    buffer.append('\n');
                    byte[] bytes = buffer.toString().getBytes(NEWSRC_ENCODING);
                    writer.write(bytes);
                }
                writer.flush();
                writer.close();
                long t2 = System.currentTimeMillis();
                if (this.debug) {
                    System.err.println("DEBUG: nntp: newsrc save: " + this.groups.size() + " groups in " + (t2 - t1) + "ms");
                }
            }
            catch (IOException e) {
                System.err.println("WARNING: nntp: unable to save newsrc file");
                if (!this.debug) break block10;
                e.printStackTrace(System.err);
            }
        }
        this.dirty = false;
    }

    @Override
    public Iterator list() {
        if (this.subs == null) {
            this.load();
        }
        return this.subs.iterator();
    }

    @Override
    public boolean isSubscribed(String newsgroup) {
        if (this.subs == null) {
            this.load();
        }
        return this.subs.contains(newsgroup);
    }

    @Override
    public void setSubscribed(String newsgroup, boolean flag) {
        if (this.subs == null) {
            this.load();
        }
        if (flag && !this.groups.contains(newsgroup)) {
            this.groups.add(newsgroup);
        }
        boolean subscribed = this.subs.contains(newsgroup);
        if (flag && !subscribed) {
            this.subs.add(newsgroup);
            this.dirty = true;
        } else if (!flag && subscribed) {
            this.subs.remove(newsgroup);
            this.dirty = true;
        }
    }

    @Override
    public boolean isSeen(String newsgroup, int article) {
        RangeList ranges;
        Object value;
        if (this.subs == null) {
            this.load();
        }
        if ((value = this.lines.get(newsgroup)) instanceof String) {
            value = new RangeList((String)value);
        }
        if ((ranges = (RangeList)value) != null) {
            return ranges.isSeen(article);
        }
        return false;
    }

    @Override
    public void setSeen(String newsgroup, int article, boolean flag) {
        RangeList ranges;
        Object value;
        if (this.subs == null) {
            this.load();
        }
        if ((value = this.lines.get(newsgroup)) instanceof String) {
            value = new RangeList((String)value);
        }
        if ((ranges = (RangeList)value) == null) {
            ranges = new RangeList();
            this.lines.put(newsgroup, ranges);
            this.dirty = true;
        }
        if (ranges.isSeen(article) != flag) {
            ranges.setSeen(article, flag);
            this.dirty = true;
        }
    }

    static class Range {
        int from;
        int to;

        public Range(int i) {
            this.from = this.to = i;
        }

        public Range(int f, int t) {
            if (f > t) {
                this.from = t;
                this.to = f;
            } else {
                this.from = f;
                this.to = t;
            }
        }

        public boolean contains(int num) {
            return num >= this.from && num <= this.to;
        }

        public String toString() {
            if (this.from != this.to) {
                return new StringBuffer().append(this.from).append('-').append(this.to).toString();
            }
            return Integer.toString(this.from);
        }
    }

    static class RangeList {
        List seen = new ArrayList();

        RangeList() {
        }

        RangeList(String line) {
            this();
            try {
                int start = 0;
                int end = line.indexOf(44);
                while (end > start) {
                    String token = line.substring(start, end);
                    this.addToken(token);
                    start = end + 1;
                    end = line.indexOf(44, start);
                }
                this.addToken(line.substring(start));
            }
            catch (NumberFormatException e) {
                System.err.println("ERROR: nntp: bad newsrc format: " + line);
            }
        }

        private void addToken(String token) throws NumberFormatException {
            int hp = token.indexOf(45);
            if (hp > -1) {
                String fs = token.substring(0, hp);
                String ts = token.substring(hp + 1);
                int from = Integer.parseInt(fs);
                int to = Integer.parseInt(ts);
                if (from > -1 && to > -1) {
                    this.insert(from, to);
                }
            } else {
                int number = Integer.parseInt(token);
                if (number > -1) {
                    this.insert(number);
                }
            }
        }

        public boolean isSeen(int num) {
            int len = this.seen.size();
            Range[] r = new Range[len];
            this.seen.toArray(r);
            for (int i = 0; i < len; ++i) {
                if (!r[i].contains(num)) continue;
                return true;
            }
            return false;
        }

        public void setSeen(int num, boolean flag) {
            if (flag) {
                this.insert(num);
            } else {
                this.remove(num);
            }
        }

        int indexOf(int num) {
            int len = this.seen.size();
            Range[] r = new Range[len];
            this.seen.toArray(r);
            for (int i = 0; i < len; ++i) {
                if (r[i].contains(num)) {
                    return i;
                }
                if (r[i].from > num) {
                    return i;
                }
                if (r[i].to != num - 1) continue;
                return i;
            }
            return len;
        }

        void insert(int start, int end) {
            Range range = new Range(start, end);
            int i1 = this.indexOf(range.from);
            if (i1 == this.seen.size()) {
                this.seen.add(range);
                return;
            }
            Range r1 = (Range)this.seen.get(i1);
            if (range.to < r1.from) {
                this.seen.add(i1, range);
                return;
            }
            if (r1.from <= range.from && r1.to >= range.to) {
                return;
            }
            int i2 = this.indexOf(range.to);
            Range r2 = (Range)this.seen.get(i2);
            System.err.println("r2 " + r2 + " i2 " + i2);
            for (int i = i2; i >= i1; --i) {
                this.seen.remove(i);
            }
            int f = range.from < r1.from ? range.from : r1.from;
            int t = range.to > r2.to ? range.to : r2.to;
            range = new Range(f, t);
            this.seen.add(i1, range);
        }

        void insert(int num) {
            this.insert(num, num);
        }

        void remove(int num) {
            Range r2;
            int i = this.indexOf(num);
            Range r = (Range)this.seen.get(i);
            this.seen.remove(i);
            if (r.from == r.to && r.to == num) {
                return;
            }
            if (r.to > num) {
                r2 = new Range(num + 1, r.to);
                this.seen.add(i, r2);
            }
            if (r.from < num) {
                r2 = new Range(r.from, num - 1);
                this.seen.add(i, r2);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int len = this.seen.size();
            for (int i = 0; i < len; ++i) {
                Range range = (Range)this.seen.get(i);
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(range.toString());
            }
            return buf.toString();
        }
    }
}

