/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseSection;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseGroup
implements JRGroup,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_HEIGHT_TO_START_NEW_PAGE = "minHeightToStartNewPage";
    public static final String PROPERTY_FOOTER_POSITION = "footerPosition";
    public static final String PROPERTY_KEEP_TOGETHER = "keepTogether";
    public static final String PROPERTY_RESET_PAGE_NUMBER = "resetPageNumber";
    public static final String PROPERTY_REPRINT_HEADER_ON_EACH_PAGE = "reprintHeaderOnEachPage";
    public static final String PROPERTY_START_NEW_COLUMN = "startNewColumn";
    public static final String PROPERTY_START_NEW_PAGE = "startNewPage";
    protected String name;
    protected boolean isStartNewColumn;
    protected boolean isStartNewPage;
    protected boolean isResetPageNumber;
    protected boolean isReprintHeaderOnEachPage;
    protected int minHeightToStartNewPage;
    protected FooterPositionEnum footerPositionValue = FooterPositionEnum.NORMAL;
    protected boolean keepTogether;
    protected JRExpression expression;
    protected JRSection groupHeaderSection;
    protected JRSection groupFooterSection;
    protected JRVariable countVariable;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte footerPosition;
    private JRBand groupHeader;
    private JRBand groupFooter;

    protected JRBaseGroup() {
    }

    protected JRBaseGroup(JRGroup group, JRBaseObjectFactory factory) {
        factory.put(group, this);
        this.name = group.getName();
        this.isStartNewColumn = group.isStartNewColumn();
        this.isStartNewPage = group.isStartNewPage();
        this.isResetPageNumber = group.isResetPageNumber();
        this.isReprintHeaderOnEachPage = group.isReprintHeaderOnEachPage();
        this.minHeightToStartNewPage = group.getMinHeightToStartNewPage();
        this.footerPositionValue = group.getFooterPositionValue();
        this.keepTogether = group.isKeepTogether();
        this.expression = factory.getExpression(group.getExpression());
        this.groupHeaderSection = factory.getSection(group.getGroupHeaderSection());
        this.groupFooterSection = factory.getSection(group.getGroupFooterSection());
        this.countVariable = factory.getVariable(group.getCountVariable());
    }

    public String getName() {
        return this.name;
    }

    public boolean isStartNewColumn() {
        return this.isStartNewColumn;
    }

    public void setStartNewColumn(boolean isStart) {
        boolean old = this.isStartNewColumn;
        this.isStartNewColumn = isStart;
        this.getEventSupport().firePropertyChange(PROPERTY_START_NEW_COLUMN, old, this.isStartNewColumn);
    }

    public boolean isStartNewPage() {
        return this.isStartNewPage;
    }

    public void setStartNewPage(boolean isStart) {
        boolean old = this.isStartNewPage;
        this.isStartNewPage = isStart;
        this.getEventSupport().firePropertyChange(PROPERTY_START_NEW_PAGE, old, this.isStartNewPage);
    }

    public boolean isResetPageNumber() {
        return this.isResetPageNumber;
    }

    public void setResetPageNumber(boolean isReset) {
        boolean old = this.isResetPageNumber;
        this.isResetPageNumber = isReset;
        this.getEventSupport().firePropertyChange(PROPERTY_RESET_PAGE_NUMBER, old, this.isResetPageNumber);
    }

    public boolean isReprintHeaderOnEachPage() {
        return this.isReprintHeaderOnEachPage;
    }

    public void setReprintHeaderOnEachPage(boolean isReprint) {
        boolean old = this.isReprintHeaderOnEachPage;
        this.isReprintHeaderOnEachPage = isReprint;
        this.getEventSupport().firePropertyChange(PROPERTY_REPRINT_HEADER_ON_EACH_PAGE, old, this.isReprintHeaderOnEachPage);
    }

    public int getMinHeightToStartNewPage() {
        return this.minHeightToStartNewPage;
    }

    public void setMinHeightToStartNewPage(int minHeight) {
        int old = this.minHeightToStartNewPage;
        this.minHeightToStartNewPage = minHeight;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_HEIGHT_TO_START_NEW_PAGE, old, this.minHeightToStartNewPage);
    }

    public FooterPositionEnum getFooterPositionValue() {
        return this.footerPositionValue;
    }

    public void setFooterPosition(FooterPositionEnum footerPositionValue) {
        FooterPositionEnum old = this.footerPositionValue;
        this.footerPositionValue = footerPositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_FOOTER_POSITION, old, this.footerPositionValue);
    }

    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(boolean keepTogether) {
        boolean old = this.keepTogether;
        this.keepTogether = keepTogether;
        this.getEventSupport().firePropertyChange(PROPERTY_KEEP_TOGETHER, old, this.keepTogether);
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRSection getGroupHeaderSection() {
        return this.groupHeaderSection;
    }

    public JRSection getGroupFooterSection() {
        return this.groupFooterSection;
    }

    public JRVariable getCountVariable() {
        return this.countVariable;
    }

    public Object clone() {
        JRBaseGroup clone = null;
        try {
            clone = (JRBaseGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.groupHeader = JRCloneUtils.nullSafeClone(this.groupHeader);
        clone.groupFooter = JRCloneUtils.nullSafeClone(this.groupFooter);
        clone.countVariable = JRCloneUtils.nullSafeClone(this.countVariable);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseGroup jRBaseGroup = this;
        synchronized (jRBaseGroup) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.footerPositionValue = this.footerPosition == 0 ? FooterPositionEnum.NORMAL : FooterPositionEnum.getByValue(this.footerPosition);
        }
        if (this.groupHeader != null) {
            this.groupHeaderSection = new JRBaseSection(this.groupHeader);
            this.groupHeader = null;
        }
        if (this.groupFooter != null) {
            this.groupFooterSection = new JRBaseSection(this.groupFooter);
            this.groupFooter = null;
        }
    }
}

