/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseTextElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseTextField
extends JRBaseTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_STRETCH_WITH_OVERFLOW = "stretchWithOverflow";
    protected boolean isStretchWithOverflow;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String pattern;
    protected Boolean isBlankWhenNull;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression patternExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;

    protected JRBaseTextField(JRTextField textField, JRBaseObjectFactory factory) {
        super(textField, factory);
        this.isStretchWithOverflow = textField.isStretchWithOverflow();
        this.evaluationTimeValue = textField.getEvaluationTimeValue();
        this.pattern = textField.getOwnPattern();
        this.isBlankWhenNull = textField.isOwnBlankWhenNull();
        this.linkType = textField.getLinkType();
        this.linkTarget = textField.getLinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(textField, factory);
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
        this.expression = factory.getExpression(textField.getExpression());
        this.patternExpression = factory.getExpression(textField.getPatternExpression());
        this.anchorNameExpression = factory.getExpression(textField.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(textField.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(textField.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(textField.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(textField.getHyperlinkTooltipExpression());
        this.bookmarkLevel = textField.getBookmarkLevel();
    }

    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
        boolean old = this.isStretchWithOverflow;
        this.isStretchWithOverflow = isStretchWithOverflow;
        this.getEventSupport().firePropertyChange(PROPERTY_STRETCH_WITH_OVERFLOW, old, this.isStretchWithOverflow);
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange("pattern", old, this.pattern);
    }

    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    public void setBlankWhenNull(Boolean isBlank) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlank;
        this.getEventSupport().firePropertyChange("blankWhenNull", old, this.isBlankWhenNull);
    }

    public void setBlankWhenNull(boolean isBlank) {
        this.setBlankWhenNull(isBlank ? Boolean.TRUE : Boolean.FALSE);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getPatternExpression() {
        return this.patternExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitTextField(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Object clone() {
        JRBaseTextField clone = (JRBaseTextField)super.clone();
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.patternExpression = JRCloneUtils.nullSafeClone(this.patternExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
    }
}

