/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRPrintBand
implements JRPrintElementContainer {
    private int height;
    private List<Object> elements = new ArrayList<Object>();
    private boolean iterated = false;

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public List<JRPrintElement> getElements() {
        throw new UnsupportedOperationException();
    }

    public Iterator<JRPrintElement> iterateElements() {
        if (this.iterated) {
            throw new IllegalStateException("Elements already iterated");
        }
        this.iterated = true;
        return new ElementsIterator(this.elements);
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.elements.add(element);
    }

    public void addOffsetElements(Collection<? extends JRPrintElement> elements, int offsetX, int offsetY) {
        if (elements.isEmpty()) {
            return;
        }
        OffsetElements offsetElements = new OffsetElements(elements, offsetX, offsetY);
        this.elements.add(offsetElements);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ElementsIterator
    implements Iterator<JRPrintElement> {
        private final Iterator<Object> iterator;
        private OffsetElements subElements;
        private Iterator<? extends JRPrintElement> subIterator;

        public ElementsIterator(List<Object> elements) {
            this.iterator = elements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.subIterator != null && this.subIterator.hasNext() || this.iterator.hasNext();
        }

        @Override
        public JRPrintElement next() {
            JRPrintElement element = null;
            if (this.subIterator != null) {
                if (this.subIterator.hasNext()) {
                    element = this.subIterator.next();
                    this.subIterator.remove();
                    this.setSubOffsets(element);
                } else {
                    this.subIterator = null;
                    this.subElements = null;
                }
            }
            if (element == null) {
                Object next = this.iterator.next();
                if (next instanceof JRPrintElement) {
                    element = (JRPrintElement)next;
                } else {
                    this.subElements = (OffsetElements)next;
                    this.subIterator = this.subElements.elements.iterator();
                    element = this.subIterator.next();
                    this.subIterator.remove();
                    this.setSubOffsets(element);
                }
            }
            return element;
        }

        protected void setSubOffsets(JRPrintElement element) {
            element.setX(this.subElements.offsetX + element.getX());
            element.setY(this.subElements.offsetY + element.getY());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OffsetElements {
        private final Collection<? extends JRPrintElement> elements;
        private final int offsetX;
        private final int offsetY;

        public OffsetElements(Collection<? extends JRPrintElement> elements, int offsetX, int offsetY) {
            this.elements = elements;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }
}

