/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRFontUtil {
    private static final Log log = LogFactory.getLog(JRFontUtil.class);
    private static final InheritableThreadLocal<Set<String>> threadMissingFontsCache = new InheritableThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public static void copyNonNullOwnProperties(JRFont srcFont, JRFont destFont) {
        if (srcFont != null && destFont != null) {
            if (srcFont.getOwnFontName() != null) {
                destFont.setFontName(srcFont.getOwnFontName());
            }
            if (srcFont.isOwnBold() != null) {
                destFont.setBold(srcFont.isOwnBold());
            }
            if (srcFont.isOwnItalic() != null) {
                destFont.setItalic(srcFont.isOwnItalic());
            }
            if (srcFont.isOwnUnderline() != null) {
                destFont.setUnderline(srcFont.isOwnUnderline());
            }
            if (srcFont.isOwnStrikeThrough() != null) {
                destFont.setStrikeThrough(srcFont.isOwnStrikeThrough());
            }
            if (srcFont.getOwnFontSize() != null) {
                destFont.setFontSize(srcFont.getOwnFontSize());
            }
            if (srcFont.getOwnPdfFontName() != null) {
                destFont.setPdfFontName(srcFont.getOwnPdfFontName());
            }
            if (srcFont.getOwnPdfEncoding() != null) {
                destFont.setPdfEncoding(srcFont.getOwnPdfEncoding());
            }
            if (srcFont.isOwnPdfEmbedded() != null) {
                destFont.setPdfEmbedded(srcFont.isOwnPdfEmbedded());
            }
        }
    }

    public static Map<AttributedCharacterIterator.Attribute, Object> getAttributes(Map<AttributedCharacterIterator.Attribute, Object> attributes, JRFont font, Locale locale) {
        Font awtFont = JRFontUtil.getAwtFontFromBundles(font.getFontName(), (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), font.getFontSize(), locale, true);
        if (awtFont != null) {
            attributes.put(TextAttribute.FONT, awtFont);
        }
        JRFontUtil.getAttributesWithoutAwtFont(attributes, font);
        return attributes;
    }

    public static Map<AttributedCharacterIterator.Attribute, Object> getAttributesWithoutAwtFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, JRFont font) {
        attributes.put(TextAttribute.FAMILY, font.getFontName());
        attributes.put(TextAttribute.SIZE, new Float(font.getFontSize()));
        if (font.isBold()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font.isItalic()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (font.isUnderline()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isStrikeThrough()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        attributes.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
        attributes.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
        if (font.isPdfEmbedded()) {
            attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
        }
        return attributes;
    }

    public static FontInfo getFontInfo(String name, Locale locale) {
        List<FontFamily> families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            if (locale != null && !family.supportsLocale(locale)) continue;
            if (name.equals(family.getName())) {
                return new FontInfo(family, null, 0);
            }
            FontFace face = family.getNormalFace();
            if (face != null && name.equals(face.getName())) {
                return new FontInfo(family, face, 0);
            }
            face = family.getBoldFace();
            if (face != null && name.equals(face.getName())) {
                return new FontInfo(family, face, 1);
            }
            face = family.getItalicFace();
            if (face != null && name.equals(face.getName())) {
                return new FontInfo(family, face, 2);
            }
            face = family.getBoldItalicFace();
            if (face == null || !name.equals(face.getName())) continue;
            return new FontInfo(family, face, 3);
        }
        return null;
    }

    public static Collection<String> getFontFamilyNames() {
        TreeSet<String> familyNames = new TreeSet<String>();
        List<FontFamily> families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            familyNames.add(family.getName());
        }
        return familyNames;
    }

    public static Font getAwtFontFromBundles(String name, int style, int size, Locale locale) {
        return JRFontUtil.getAwtFontFromBundles(name, style, size, locale, true);
    }

    public static Font getAwtFontFromBundles(String name, int style, int size, Locale locale, boolean ignoreMissingFont) {
        Font awtFont = null;
        FontInfo fontInfo = JRFontUtil.getFontInfo(name, locale);
        if (fontInfo != null) {
            int faceStyle = 0;
            FontFamily family = fontInfo.getFontFamily();
            FontFace face = fontInfo.getFontFace();
            if (face == null) {
                if ((style & 1) > 0 && (style & 2) > 0) {
                    face = family.getBoldItalicFace();
                    faceStyle = 3;
                }
                if (face == null && (style & 1) > 0) {
                    face = family.getBoldFace();
                    faceStyle = 1;
                }
                if (face == null && (style & 2) > 0) {
                    face = family.getItalicFace();
                    faceStyle = 2;
                }
                if (face == null) {
                    face = family.getNormalFace();
                    faceStyle = 0;
                }
            } else {
                faceStyle = fontInfo.getStyle();
            }
            if (face == null) {
                JRFontUtil.checkAwtFont(family.getName(), ignoreMissingFont);
                awtFont = new Font(family.getName(), style, size);
            } else {
                awtFont = face.getFont();
                if (awtFont == null) {
                    throw new JRRuntimeException("The '" + face.getName() + "' font face in family '" + family.getName() + "' returns a null font.");
                }
                awtFont = awtFont.deriveFont((float)size);
                awtFont = awtFont.deriveFont(style & ~faceStyle);
            }
        }
        return awtFont;
    }

    public static void resetThreadMissingFontsCache() {
        threadMissingFontsCache.set(new HashSet());
    }

    public static void checkAwtFont(String name, boolean ignoreMissingFont) {
        if (!JRGraphEnvInitializer.isAwtFontAvailable(name)) {
            if (ignoreMissingFont) {
                Set missingFontNames = (Set)threadMissingFontsCache.get();
                if (!missingFontNames.contains(name)) {
                    missingFontNames.add(name);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Font '" + name + "' is not available to the JVM. For more details, see http://jasperreports.sourceforge.net/api/net/sf/jasperreports/engine/util/JRFontNotFoundException.html"));
                    }
                }
            } else {
                throw new JRFontNotFoundException(name);
            }
        }
    }

    public static Font getAwtFont(JRFont font, Locale locale) {
        if (font == null) {
            return null;
        }
        Font awtFont = JRFontUtil.getAwtFontFromBundles(font.getFontName(), (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), font.getFontSize(), locale, true);
        if (awtFont == null) {
            awtFont = new Font(JRFontUtil.getAttributesWithoutAwtFont(new HashMap<AttributedCharacterIterator.Attribute, Object>(), font));
        } else {
            HashMap<TextAttribute, Constable> attributes = new HashMap<TextAttribute, Constable>();
            if (font.isUnderline()) {
                attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (font.isStrikeThrough()) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (!attributes.isEmpty()) {
                awtFont = awtFont.deriveFont(attributes);
            }
        }
        return awtFont;
    }

    private JRFontUtil() {
    }
}

