/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public abstract class JRBaseCrosstabGroup
implements JRCrosstabGroup,
Serializable {
    private static final long serialVersionUID = 7685014062058258277L;
    protected String name;
    protected CrosstabTotalPositionEnum totalPositionValue = CrosstabTotalPositionEnum.NONE;
    protected JRCrosstabBucket bucket;
    protected JRCellContents header;
    protected JRCellContents totalHeader;
    protected JRVariable variable;
    private int PSEUDO_SERIAL_VERSION_UID = 30705;
    private byte totalPosition;

    protected JRBaseCrosstabGroup() {
    }

    public JRBaseCrosstabGroup(JRCrosstabGroup group, JRBaseObjectFactory factory) {
        factory.put(group, this);
        this.name = group.getName();
        this.totalPositionValue = group.getTotalPositionValue();
        this.bucket = factory.getCrosstabBucket(group.getBucket());
        this.header = factory.getCell(group.getHeader());
        this.totalHeader = factory.getCell(group.getTotalHeader());
        this.variable = factory.getVariable(group.getVariable());
    }

    public String getName() {
        return this.name;
    }

    public JRCrosstabBucket getBucket() {
        return this.bucket;
    }

    public byte getTotalPosition() {
        return this.getTotalPositionValue().getValue();
    }

    public CrosstabTotalPositionEnum getTotalPositionValue() {
        return this.totalPositionValue;
    }

    public boolean hasTotal() {
        return this.totalPositionValue != CrosstabTotalPositionEnum.NONE;
    }

    public JRCellContents getHeader() {
        return this.header;
    }

    public JRCellContents getTotalHeader() {
        return this.totalHeader;
    }

    public JRVariable getVariable() {
        return this.variable;
    }

    public Object clone() {
        try {
            JRBaseCrosstabGroup clone = (JRBaseCrosstabGroup)super.clone();
            clone.bucket = (JRCrosstabBucket)JRCloneUtils.nullSafeClone(this.bucket);
            clone.header = (JRCellContents)JRCloneUtils.nullSafeClone(this.header);
            clone.totalHeader = (JRCellContents)JRCloneUtils.nullSafeClone(this.totalHeader);
            clone.variable = (JRVariable)JRCloneUtils.nullSafeClone(this.variable);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.totalPositionValue = CrosstabTotalPositionEnum.getByValue(this.totalPosition);
        }
    }
}

