/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignSubreport
extends JRDesignElement
implements JRSubreport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CONNECTION_EXPRESSION = "connectionExpression";
    public static final String PROPERTY_DATASOURCE_EXPRESSION = "dataSourceExpression";
    public static final String PROPERTY_EXPRESSION = "expression";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_RETURN_VALUES = "returnValues";
    protected Boolean isUsingCache;
    private Boolean runToBottom;
    protected Map<String, JRSubreportParameter> parametersMap = new LinkedHashMap<String, JRSubreportParameter>();
    protected List<JRSubreportReturnValue> returnValues = new ArrayList<JRSubreportReturnValue>();
    protected JRExpression parametersMapExpression;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;
    protected JRExpression expression;

    public JRDesignSubreport(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            JRExpression subreportExpression = this.getExpression();
            if (subreportExpression != null) {
                return String.class.getName().equals(subreportExpression.getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void setParametersMapExpression(JRExpression parametersMapExpression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = parametersMapExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        JRSubreportParameter[] parametersArray = new JRSubreportParameter[this.parametersMap.size()];
        this.parametersMap.values().toArray(parametersArray);
        return parametersArray;
    }

    public Map<String, JRSubreportParameter> getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(JRSubreportParameter subreportParameter) throws JRException {
        if (this.parametersMap.containsKey(subreportParameter.getName())) {
            throw new JRException("Duplicate declaration of subreport parameter : " + subreportParameter.getName());
        }
        this.parametersMap.put(subreportParameter.getName(), subreportParameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, subreportParameter, this.parametersMap.size() - 1);
    }

    public JRSubreportParameter removeParameter(String name) {
        JRSubreportParameter removed = this.parametersMap.remove(name);
        if (removed != null) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, removed, -1);
        }
        return removed;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public void setConnectionExpression(JRExpression connectionExpression) {
        JRExpression old = this.connectionExpression;
        this.connectionExpression = connectionExpression;
        if (this.connectionExpression != null) {
            this.setDataSourceExpression(null);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CONNECTION_EXPRESSION, old, this.connectionExpression);
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public void setDataSourceExpression(JRExpression dataSourceExpression) {
        JRExpression old = this.dataSourceExpression;
        this.dataSourceExpression = dataSourceExpression;
        if (this.dataSourceExpression != null) {
            this.setConnectionExpression(null);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_DATASOURCE_EXPRESSION, old, this.dataSourceExpression);
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitSubreport(this);
    }

    public void addReturnValue(JRSubreportReturnValue returnValue) {
        this.returnValues.add(returnValue);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_RETURN_VALUES, returnValue, this.returnValues.size() - 1);
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        JRSubreportReturnValue[] returnValuesArray = new JRSubreportReturnValue[this.returnValues.size()];
        this.returnValues.toArray(returnValuesArray);
        return returnValuesArray;
    }

    public List<JRSubreportReturnValue> getReturnValuesList() {
        return this.returnValues;
    }

    public boolean removeReturnValue(JRSubreportReturnValue returnValue) {
        int idx = this.returnValues.indexOf(returnValue);
        if (idx >= 0) {
            this.returnValues.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_RETURN_VALUES, returnValue, idx);
            return true;
        }
        return false;
    }

    @Override
    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("isUsingCache", old, this.isUsingCache);
    }

    @Override
    public Boolean isRunToBottom() {
        return this.runToBottom;
    }

    @Override
    public void setRunToBottom(Boolean runToBottom) {
        Boolean old = this.runToBottom;
        this.runToBottom = runToBottom;
        this.getEventSupport().firePropertyChange("runToBottom", old, this.runToBottom);
    }

    @Override
    public Object clone() {
        JRDesignSubreport clone = (JRDesignSubreport)super.clone();
        if (this.parametersMap != null) {
            clone.parametersMap = new LinkedHashMap<String, JRSubreportParameter>();
            Iterator<String> it = this.parametersMap.keySet().iterator();
            while (it.hasNext()) {
                clone.parametersMap.put(this.key, (JRSubreportParameter)JRCloneUtils.nullSafeClone((JRCloneable)this.parametersMap.get(it.next())));
            }
        }
        clone.returnValues = JRCloneUtils.cloneList(this.returnValues);
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.connectionExpression = JRCloneUtils.nullSafeClone(this.connectionExpression);
        clone.dataSourceExpression = JRCloneUtils.nullSafeClone(this.dataSourceExpression);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        return clone;
    }
}

